<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPhone StructType
 * @subpackage Structs
 */
class LPhone extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The numberOfButtons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfButtons;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $primaryPhoneName;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The idleTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleTimeout;
    /**
     * The authenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationUrl;
    /**
     * The directoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUrl;
    /**
     * The idleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $idleUrl;
    /**
     * The informationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $informationUrl;
    /**
     * The messagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messagesUrl;
    /**
     * The proxyServerUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $proxyServerUrl;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicesUrl;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $loginUserId;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $defaultProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The currentProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $currentProfileName;
    /**
     * The loginTime
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginTime;
    /**
     * The loginDuration
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginDuration;
    /**
     * The currentConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentConfig
     */
    public $currentConfig;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $builtInBridgeStatus;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The hlogStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The allowCtiControlFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requireDtmfReception
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - documentation: keyOrder can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - documentation: ecKeySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ecKeySize;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: authenticationString can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $authenticationString;
    /**
     * The certificateStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificateStatus;
    /**
     * The upgradeFinishTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $upgradeFinishTime;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The roamingDevicePoolName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only.Specifies the device pool being used if the device is roaming and the deviceMobility feature is enabled for it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $roamingDevicePoolName;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The isActive
     * Meta informations extracted from the WSDL
     * - documentation: This tag determines if the newly added phone is active to determine consumption of license.If set to false the license units will not be consumed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The isDualMode
     * Meta informations extracted from the WSDL
     * - documentation: Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDualMode;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The isProtected
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support Secure Tone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isProtected;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dialRulesName;
    /**
     * The sshUserId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $sshUserId;
    /**
     * The digestUser
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $digestUser;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for PLAR-supporting SIP/SCCP phones only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureDirectoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureDirectoryUrl;
    /**
     * The secureMessageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureMessageUrl;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceTrustMode;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The requireThirdPartyRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireThirdPartyRegistration;
    /**
     * The blockIncomingCallsWhenRoaming
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockIncomingCallsWhenRoaming;
    /**
     * The homeNetworkId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is only valid when value of blockIncomingCallsWhenRoaming is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homeNetworkId;
    /**
     * The AllowPresentationSharingUsingBfcp
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $AllowPresentationSharingUsingBfcp;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The requireOffPremiseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The allowiXApplicableMedia
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicableMedia;
    /**
     * The enableCallRoutingToRdWhenNoneIsActive
     * Meta informations extracted from the WSDL
     * - documentation: The new enableCallRoutingToRdWhenNoneIsActive flag for Remote Destination Call Forwarding feature is required for CTI Remote Device. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCallRoutingToRdWhenNoneIsActive;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPhone
     * @uses LPhone::setName()
     * @uses LPhone::setDescription()
     * @uses LPhone::setProduct()
     * @uses LPhone::setModel()
     * @uses LPhone::setClass()
     * @uses LPhone::setProtocol()
     * @uses LPhone::setProtocolSide()
     * @uses LPhone::setCallingSearchSpaceName()
     * @uses LPhone::setDevicePoolName()
     * @uses LPhone::setCommonDeviceConfigName()
     * @uses LPhone::setCommonPhoneConfigName()
     * @uses LPhone::setNetworkLocation()
     * @uses LPhone::setLocationName()
     * @uses LPhone::setMediaResourceListName()
     * @uses LPhone::setNetworkHoldMohAudioSourceId()
     * @uses LPhone::setUserHoldMohAudioSourceId()
     * @uses LPhone::setAutomatedAlternateRoutingCssName()
     * @uses LPhone::setAarNeighborhoodName()
     * @uses LPhone::setLoadInformation()
     * @uses LPhone::setTraceFlag()
     * @uses LPhone::setMlppIndicationStatus()
     * @uses LPhone::setPreemption()
     * @uses LPhone::setUseTrustedRelayPoint()
     * @uses LPhone::setRetryVideoCallAsAudio()
     * @uses LPhone::setSecurityProfileName()
     * @uses LPhone::setSipProfileName()
     * @uses LPhone::setCgpnTransformationCssName()
     * @uses LPhone::setUseDevicePoolCgpnTransformCss()
     * @uses LPhone::setGeoLocationName()
     * @uses LPhone::setGeoLocationFilterName()
     * @uses LPhone::setSendGeoLocation()
     * @uses LPhone::setNumberOfButtons()
     * @uses LPhone::setPhoneTemplateName()
     * @uses LPhone::setPrimaryPhoneName()
     * @uses LPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses LPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses LPhone::setUserLocale()
     * @uses LPhone::setNetworkLocale()
     * @uses LPhone::setIdleTimeout()
     * @uses LPhone::setAuthenticationUrl()
     * @uses LPhone::setDirectoryUrl()
     * @uses LPhone::setIdleUrl()
     * @uses LPhone::setInformationUrl()
     * @uses LPhone::setMessagesUrl()
     * @uses LPhone::setProxyServerUrl()
     * @uses LPhone::setServicesUrl()
     * @uses LPhone::setSoftkeyTemplateName()
     * @uses LPhone::setLoginUserId()
     * @uses LPhone::setDefaultProfileName()
     * @uses LPhone::setEnableExtensionMobility()
     * @uses LPhone::setCurrentProfileName()
     * @uses LPhone::setLoginTime()
     * @uses LPhone::setLoginDuration()
     * @uses LPhone::setCurrentConfig()
     * @uses LPhone::setSingleButtonBarge()
     * @uses LPhone::setJoinAcrossLines()
     * @uses LPhone::setBuiltInBridgeStatus()
     * @uses LPhone::setCallInfoPrivacyStatus()
     * @uses LPhone::setHlogStatus()
     * @uses LPhone::setOwnerUserName()
     * @uses LPhone::setIgnorePresentationIndicators()
     * @uses LPhone::setPacketCaptureMode()
     * @uses LPhone::setPacketCaptureDuration()
     * @uses LPhone::setSubscribeCallingSearchSpaceName()
     * @uses LPhone::setRerouteCallingSearchSpaceName()
     * @uses LPhone::setAllowCtiControlFlag()
     * @uses LPhone::setPresenceGroupName()
     * @uses LPhone::setUnattendedPort()
     * @uses LPhone::setRequireDtmfReception()
     * @uses LPhone::setRfc2833Disabled()
     * @uses LPhone::setCertificateOperation()
     * @uses LPhone::setAuthenticationMode()
     * @uses LPhone::setKeySize()
     * @uses LPhone::setKeyOrder()
     * @uses LPhone::setEcKeySize()
     * @uses LPhone::setAuthenticationString()
     * @uses LPhone::setCertificateStatus()
     * @uses LPhone::setUpgradeFinishTime()
     * @uses LPhone::setDeviceMobilityMode()
     * @uses LPhone::setRoamingDevicePoolName()
     * @uses LPhone::setRemoteDevice()
     * @uses LPhone::setDndOption()
     * @uses LPhone::setDndRingSetting()
     * @uses LPhone::setDndStatus()
     * @uses LPhone::setIsActive()
     * @uses LPhone::setIsDualMode()
     * @uses LPhone::setMobilityUserIdName()
     * @uses LPhone::setPhoneSuite()
     * @uses LPhone::setPhoneServiceDisplay()
     * @uses LPhone::setIsProtected()
     * @uses LPhone::setMtpRequired()
     * @uses LPhone::setMtpPreferedCodec()
     * @uses LPhone::setDialRulesName()
     * @uses LPhone::setSshUserId()
     * @uses LPhone::setDigestUser()
     * @uses LPhone::setOutboundCallRollover()
     * @uses LPhone::setHotlineDevice()
     * @uses LPhone::setSecureInformationUrl()
     * @uses LPhone::setSecureDirectoryUrl()
     * @uses LPhone::setSecureMessageUrl()
     * @uses LPhone::setSecureServicesUrl()
     * @uses LPhone::setSecureAuthenticationUrl()
     * @uses LPhone::setSecureIdleUrl()
     * @uses LPhone::setAlwaysUsePrimeLine()
     * @uses LPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LPhone::setFeatureControlPolicy()
     * @uses LPhone::setDeviceTrustMode()
     * @uses LPhone::setEarlyOfferSupportForVoiceCall()
     * @uses LPhone::setRequireThirdPartyRegistration()
     * @uses LPhone::setBlockIncomingCallsWhenRoaming()
     * @uses LPhone::setHomeNetworkId()
     * @uses LPhone::setAllowPresentationSharingUsingBfcp()
     * @uses LPhone::setConfidentialAccess()
     * @uses LPhone::setRequireOffPremiseLocation()
     * @uses LPhone::setAllowiXApplicableMedia()
     * @uses LPhone::setEnableCallRoutingToRdWhenNoneIsActive()
     * @uses LPhone::setCtiid()
     * @uses LPhone::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param \StructType\XFkType $commonPhoneConfigName
     * @param string $networkLocation
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XLoadInformation $loadInformation
     * @param string $traceFlag
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $securityProfileName
     * @param \StructType\XFkType $sipProfileName
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param string $numberOfButtons
     * @param \StructType\XFkType $phoneTemplateName
     * @param \StructType\XFkType $primaryPhoneName
     * @param string $ringSettingIdleBlfAudibleAlert
     * @param string $ringSettingBusyBlfAudibleAlert
     * @param string $userLocale
     * @param string $networkLocale
     * @param string $idleTimeout
     * @param string $authenticationUrl
     * @param string $directoryUrl
     * @param string $idleUrl
     * @param string $informationUrl
     * @param string $messagesUrl
     * @param string $proxyServerUrl
     * @param string $servicesUrl
     * @param \StructType\XFkType $softkeyTemplateName
     * @param string $loginUserId
     * @param \StructType\XFkType $defaultProfileName
     * @param string $enableExtensionMobility
     * @param \StructType\XFkType $currentProfileName
     * @param string $loginTime
     * @param string $loginDuration
     * @param \StructType\CurrentConfig $currentConfig
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $builtInBridgeStatus
     * @param string $callInfoPrivacyStatus
     * @param string $hlogStatus
     * @param \StructType\XFkType $ownerUserName
     * @param string $ignorePresentationIndicators
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \StructType\XFkType $rerouteCallingSearchSpaceName
     * @param string $allowCtiControlFlag
     * @param \StructType\XFkType $presenceGroupName
     * @param string $unattendedPort
     * @param string $requireDtmfReception
     * @param string $rfc2833Disabled
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $keyOrder
     * @param string $ecKeySize
     * @param string $authenticationString
     * @param string $certificateStatus
     * @param string $upgradeFinishTime
     * @param string $deviceMobilityMode
     * @param \StructType\XFkType $roamingDevicePoolName
     * @param string $remoteDevice
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param string $isActive
     * @param string $isDualMode
     * @param \StructType\XFkType $mobilityUserIdName
     * @param string $phoneSuite
     * @param string $phoneServiceDisplay
     * @param string $isProtected
     * @param string $mtpRequired
     * @param string $mtpPreferedCodec
     * @param \StructType\XFkType $dialRulesName
     * @param string $sshUserId
     * @param string $digestUser
     * @param string $outboundCallRollover
     * @param string $hotlineDevice
     * @param string $secureInformationUrl
     * @param string $secureDirectoryUrl
     * @param string $secureMessageUrl
     * @param string $secureServicesUrl
     * @param string $secureAuthenticationUrl
     * @param string $secureIdleUrl
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\XFkType $featureControlPolicy
     * @param string $deviceTrustMode
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $requireThirdPartyRegistration
     * @param string $blockIncomingCallsWhenRoaming
     * @param string $homeNetworkId
     * @param string $allowPresentationSharingUsingBfcp
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param string $requireOffPremiseLocation
     * @param string $allowiXApplicableMedia
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, \StructType\XFkType $commonPhoneConfigName = null, $networkLocation = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XLoadInformation $loadInformation = null, $traceFlag = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \StructType\XFkType $securityProfileName = null, \StructType\XFkType $sipProfileName = null, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, $numberOfButtons = null, \StructType\XFkType $phoneTemplateName = null, \StructType\XFkType $primaryPhoneName = null, $ringSettingIdleBlfAudibleAlert = null, $ringSettingBusyBlfAudibleAlert = null, $userLocale = null, $networkLocale = null, $idleTimeout = null, $authenticationUrl = null, $directoryUrl = null, $idleUrl = null, $informationUrl = null, $messagesUrl = null, $proxyServerUrl = null, $servicesUrl = null, \StructType\XFkType $softkeyTemplateName = null, $loginUserId = null, \StructType\XFkType $defaultProfileName = null, $enableExtensionMobility = null, \StructType\XFkType $currentProfileName = null, $loginTime = null, $loginDuration = null, \StructType\CurrentConfig $currentConfig = null, $singleButtonBarge = null, $joinAcrossLines = null, $builtInBridgeStatus = null, $callInfoPrivacyStatus = null, $hlogStatus = null, \StructType\XFkType $ownerUserName = null, $ignorePresentationIndicators = null, $packetCaptureMode = null, $packetCaptureDuration = null, \StructType\XFkType $subscribeCallingSearchSpaceName = null, \StructType\XFkType $rerouteCallingSearchSpaceName = null, $allowCtiControlFlag = null, \StructType\XFkType $presenceGroupName = null, $unattendedPort = null, $requireDtmfReception = null, $rfc2833Disabled = null, $certificateOperation = null, $authenticationMode = null, $keySize = null, $keyOrder = null, $ecKeySize = null, $authenticationString = null, $certificateStatus = null, $upgradeFinishTime = null, $deviceMobilityMode = null, \StructType\XFkType $roamingDevicePoolName = null, $remoteDevice = null, $dndOption = null, $dndRingSetting = null, $dndStatus = null, $isActive = null, $isDualMode = null, \StructType\XFkType $mobilityUserIdName = null, $phoneSuite = null, $phoneServiceDisplay = null, $isProtected = null, $mtpRequired = null, $mtpPreferedCodec = null, \StructType\XFkType $dialRulesName = null, $sshUserId = null, $digestUser = null, $outboundCallRollover = null, $hotlineDevice = null, $secureInformationUrl = null, $secureDirectoryUrl = null, $secureMessageUrl = null, $secureServicesUrl = null, $secureAuthenticationUrl = null, $secureIdleUrl = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \StructType\XFkType $featureControlPolicy = null, $deviceTrustMode = null, $earlyOfferSupportForVoiceCall = null, $requireThirdPartyRegistration = null, $blockIncomingCallsWhenRoaming = null, $homeNetworkId = null, $allowPresentationSharingUsingBfcp = null, \StructType\ConfidentialAccess $confidentialAccess = null, $requireOffPremiseLocation = null, $allowiXApplicableMedia = null, $enableCallRoutingToRdWhenNoneIsActive = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setTraceFlag($traceFlag)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setNumberOfButtons($numberOfButtons)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setIdleTimeout($idleTimeout)
            ->setAuthenticationUrl($authenticationUrl)
            ->setDirectoryUrl($directoryUrl)
            ->setIdleUrl($idleUrl)
            ->setInformationUrl($informationUrl)
            ->setMessagesUrl($messagesUrl)
            ->setProxyServerUrl($proxyServerUrl)
            ->setServicesUrl($servicesUrl)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setLoginUserId($loginUserId)
            ->setDefaultProfileName($defaultProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setCurrentProfileName($currentProfileName)
            ->setLoginTime($loginTime)
            ->setLoginDuration($loginDuration)
            ->setCurrentConfig($currentConfig)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnattendedPort($unattendedPort)
            ->setRequireDtmfReception($requireDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setAuthenticationString($authenticationString)
            ->setCertificateStatus($certificateStatus)
            ->setUpgradeFinishTime($upgradeFinishTime)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setRoamingDevicePoolName($roamingDevicePoolName)
            ->setRemoteDevice($remoteDevice)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setIsActive($isActive)
            ->setIsDualMode($isDualMode)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setIsProtected($isProtected)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setSshUserId($sshUserId)
            ->setDigestUser($digestUser)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setHotlineDevice($hotlineDevice)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureDirectoryUrl($secureDirectoryUrl)
            ->setSecureMessageUrl($secureMessageUrl)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setRequireThirdPartyRegistration($requireThirdPartyRegistration)
            ->setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming)
            ->setHomeNetworkId($homeNetworkId)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setConfidentialAccess($confidentialAccess)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setAllowiXApplicableMedia($allowiXApplicableMedia)
            ->setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LPhone
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LPhone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\LPhone
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \StructType\LPhone
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\LPhone
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\LPhone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\LPhone
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\LPhone
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\LPhone
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\LPhone
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \StructType\XFkType $commonPhoneConfigName
     * @return \StructType\LPhone
     */
    public function setCommonPhoneConfigName(\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \EnumType\XNetworkLocation::valueIsValid()
     * @uses \EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \StructType\LPhone
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\LPhone
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\LPhone
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \StructType\LPhone
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \StructType\LPhone
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\LPhone
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\LPhone
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\LPhone
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\LPhone
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\LPhone
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\LPhone
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\LPhone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\LPhone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\XFkType $securityProfileName
     * @return \StructType\LPhone
     */
    public function setSecurityProfileName(\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \StructType\XFkType $sipProfileName
     * @return \StructType\LPhone
     */
    public function setSipProfileName(\StructType\XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\LPhone
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\LPhone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\LPhone
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\LPhone
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \StructType\LPhone
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get numberOfButtons value
     * @return string|null
     */
    public function getNumberOfButtons()
    {
        return $this->numberOfButtons;
    }
    /**
     * Set numberOfButtons value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfButtons
     * @return \StructType\LPhone
     */
    public function setNumberOfButtons($numberOfButtons = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($numberOfButtons)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfButtons, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfButtons = $numberOfButtons;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\XFkType $phoneTemplateName
     * @return \StructType\LPhone
     */
    public function setPhoneTemplateName(\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \StructType\XFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \StructType\XFkType $primaryPhoneName
     * @return \StructType\LPhone
     */
    public function setPrimaryPhoneName(\StructType\XFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdleBlfAudibleAlert
     * @return \StructType\LPhone
     */
    public function setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($ringSettingIdleBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdleBlfAudibleAlert, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingBusyBlfAudibleAlert
     * @return \StructType\LPhone
     */
    public function setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($ringSettingBusyBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingBusyBlfAudibleAlert, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\LPhone
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\LPhone
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get idleTimeout value
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return $this->idleTimeout;
    }
    /**
     * Set idleTimeout value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimeout
     * @return \StructType\LPhone
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($idleTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimeout, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->idleTimeout = $idleTimeout;
        return $this;
    }
    /**
     * Get authenticationUrl value
     * @return string|null
     */
    public function getAuthenticationUrl()
    {
        return $this->authenticationUrl;
    }
    /**
     * Set authenticationUrl value
     * @param string $authenticationUrl
     * @return \StructType\LPhone
     */
    public function setAuthenticationUrl($authenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationUrl) && !is_string($authenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationUrl)), __LINE__);
        }
        $this->authenticationUrl = $authenticationUrl;
        return $this;
    }
    /**
     * Get directoryUrl value
     * @return string|null
     */
    public function getDirectoryUrl()
    {
        return $this->directoryUrl;
    }
    /**
     * Set directoryUrl value
     * @param string $directoryUrl
     * @return \StructType\LPhone
     */
    public function setDirectoryUrl($directoryUrl = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUrl) && !is_string($directoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUrl)), __LINE__);
        }
        $this->directoryUrl = $directoryUrl;
        return $this;
    }
    /**
     * Get idleUrl value
     * @return string|null
     */
    public function getIdleUrl()
    {
        return $this->idleUrl;
    }
    /**
     * Set idleUrl value
     * @param string $idleUrl
     * @return \StructType\LPhone
     */
    public function setIdleUrl($idleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($idleUrl) && !is_string($idleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idleUrl)), __LINE__);
        }
        $this->idleUrl = $idleUrl;
        return $this;
    }
    /**
     * Get informationUrl value
     * @return string|null
     */
    public function getInformationUrl()
    {
        return $this->informationUrl;
    }
    /**
     * Set informationUrl value
     * @param string $informationUrl
     * @return \StructType\LPhone
     */
    public function setInformationUrl($informationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($informationUrl) && !is_string($informationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informationUrl)), __LINE__);
        }
        $this->informationUrl = $informationUrl;
        return $this;
    }
    /**
     * Get messagesUrl value
     * @return string|null
     */
    public function getMessagesUrl()
    {
        return $this->messagesUrl;
    }
    /**
     * Set messagesUrl value
     * @param string $messagesUrl
     * @return \StructType\LPhone
     */
    public function setMessagesUrl($messagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($messagesUrl) && !is_string($messagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messagesUrl)), __LINE__);
        }
        $this->messagesUrl = $messagesUrl;
        return $this;
    }
    /**
     * Get proxyServerUrl value
     * @return string|null
     */
    public function getProxyServerUrl()
    {
        return $this->proxyServerUrl;
    }
    /**
     * Set proxyServerUrl value
     * @param string $proxyServerUrl
     * @return \StructType\LPhone
     */
    public function setProxyServerUrl($proxyServerUrl = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServerUrl) && !is_string($proxyServerUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServerUrl)), __LINE__);
        }
        $this->proxyServerUrl = $proxyServerUrl;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \StructType\LPhone
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\XFkType $softkeyTemplateName
     * @return \StructType\LPhone
     */
    public function setSoftkeyTemplateName(\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return string|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param string $loginUserId
     * @return \StructType\LPhone
     */
    public function setLoginUserId($loginUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($loginUserId) && strlen($loginUserId) > 255) || (is_array($loginUserId) && count($loginUserId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($loginUserId) ? strlen($loginUserId) : count($loginUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loginUserId) && !is_string($loginUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserId)), __LINE__);
        }
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return \StructType\XFkType|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param \StructType\XFkType $defaultProfileName
     * @return \StructType\LPhone
     */
    public function setDefaultProfileName(\StructType\XFkType $defaultProfileName = null)
    {
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \StructType\LPhone
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get currentProfileName value
     * @return \StructType\XFkType|null
     */
    public function getCurrentProfileName()
    {
        return $this->currentProfileName;
    }
    /**
     * Set currentProfileName value
     * @param \StructType\XFkType $currentProfileName
     * @return \StructType\LPhone
     */
    public function setCurrentProfileName(\StructType\XFkType $currentProfileName = null)
    {
        $this->currentProfileName = $currentProfileName;
        return $this;
    }
    /**
     * Get loginTime value
     * @return string|null
     */
    public function getLoginTime()
    {
        return $this->loginTime;
    }
    /**
     * Set loginTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginTime
     * @return \StructType\LPhone
     */
    public function setLoginTime($loginTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($loginTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginTime = $loginTime;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return string|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginDuration
     * @return \StructType\LPhone
     */
    public function setLoginDuration($loginDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($loginDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get currentConfig value
     * @return \StructType\CurrentConfig|null
     */
    public function getCurrentConfig()
    {
        return $this->currentConfig;
    }
    /**
     * Set currentConfig value
     * @param \StructType\CurrentConfig $currentConfig
     * @return \StructType\LPhone
     */
    public function setCurrentConfig(\StructType\CurrentConfig $currentConfig = null)
    {
        $this->currentConfig = $currentConfig;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\LPhone
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\LPhone
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return string|null
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridgeStatus
     * @return \StructType\LPhone
     */
    public function setBuiltInBridgeStatus($builtInBridgeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($builtInBridgeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridgeStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \StructType\LPhone
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hlogStatus
     * @return \StructType\LPhone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hlogStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \StructType\XFkType $ownerUserName
     * @return \StructType\LPhone
     */
    public function setOwnerUserName(\StructType\XFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \StructType\LPhone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\LPhone
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\LPhone
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \StructType\LPhone
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param \StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \StructType\LPhone
     */
    public function setRerouteCallingSearchSpaceName(\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \StructType\LPhone
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCtiControlFlag)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\LPhone
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\LPhone
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requireDtmfReception value
     * @return string|null
     */
    public function getRequireDtmfReception()
    {
        return $this->requireDtmfReception;
    }
    /**
     * Set requireDtmfReception value
     * @param string $requireDtmfReception
     * @return \StructType\LPhone
     */
    public function setRequireDtmfReception($requireDtmfReception = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireDtmfReception) && !is_string($requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireDtmfReception)), __LINE__);
        }
        $this->requireDtmfReception = $requireDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \StructType\LPhone
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \EnumType\XCertificateOperation::valueIsValid()
     * @uses \EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \StructType\LPhone
     */
    public function setCertificateOperation($certificateOperation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', \EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\LPhone
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\LPhone
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return string|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @uses \EnumType\XKeyOrder::valueIsValid()
     * @uses \EnumType\XKeyOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keyOrder
     * @return \StructType\LPhone
     */
    public function setKeyOrder($keyOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeyOrder::valueIsValid($keyOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keyOrder, implode(', ', \EnumType\XKeyOrder::getValidValues())), __LINE__);
        }
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return string|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @uses \EnumType\XECKeySize::valueIsValid()
     * @uses \EnumType\XECKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecKeySize
     * @return \StructType\LPhone
     */
    public function setEcKeySize($ecKeySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XECKeySize::valueIsValid($ecKeySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecKeySize, implode(', ', \EnumType\XECKeySize::getValidValues())), __LINE__);
        }
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\LPhone
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authenticationString) && strlen($authenticationString) > 128) || (is_array($authenticationString) && count($authenticationString) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($authenticationString) ? strlen($authenticationString) : count($authenticationString)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get certificateStatus value
     * @return string|null
     */
    public function getCertificateStatus()
    {
        return $this->certificateStatus;
    }
    /**
     * Set certificateStatus value
     * @uses \EnumType\XCertificateStatus::valueIsValid()
     * @uses \EnumType\XCertificateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateStatus
     * @return \StructType\LPhone
     */
    public function setCertificateStatus($certificateStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateStatus::valueIsValid($certificateStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateStatus, implode(', ', \EnumType\XCertificateStatus::getValidValues())), __LINE__);
        }
        $this->certificateStatus = $certificateStatus;
        return $this;
    }
    /**
     * Get upgradeFinishTime value
     * @return string|null
     */
    public function getUpgradeFinishTime()
    {
        return $this->upgradeFinishTime;
    }
    /**
     * Set upgradeFinishTime value
     * @param string $upgradeFinishTime
     * @return \StructType\LPhone
     */
    public function setUpgradeFinishTime($upgradeFinishTime = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeFinishTime) && !is_string($upgradeFinishTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($upgradeFinishTime)), __LINE__);
        }
        $this->upgradeFinishTime = $upgradeFinishTime;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string|null
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return \StructType\LPhone
     */
    public function setDeviceMobilityMode($deviceMobilityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get roamingDevicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getRoamingDevicePoolName()
    {
        return $this->roamingDevicePoolName;
    }
    /**
     * Set roamingDevicePoolName value
     * @param \StructType\XFkType $roamingDevicePoolName
     * @return \StructType\LPhone
     */
    public function setRoamingDevicePoolName(\StructType\XFkType $roamingDevicePoolName = null)
    {
        $this->roamingDevicePoolName = $roamingDevicePoolName;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \StructType\LPhone
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \EnumType\XDNDOption::valueIsValid()
     * @uses \EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \StructType\LPhone
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \StructType\LPhone
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \StructType\LPhone
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return \StructType\LPhone
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActive) && !is_string($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get isDualMode value
     * @return string|null
     */
    public function getIsDualMode()
    {
        return $this->isDualMode;
    }
    /**
     * Set isDualMode value
     * @param string $isDualMode
     * @return \StructType\LPhone
     */
    public function setIsDualMode($isDualMode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDualMode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDualMode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDualMode) && !is_string($isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDualMode)), __LINE__);
        }
        $this->isDualMode = $isDualMode;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * @return \StructType\XFkType|null
     */
    public function getMobilityUserIdName()
    {
        return $this->mobilityUserIdName;
    }
    /**
     * Set mobilityUserIdName value
     * @param \StructType\XFkType $mobilityUserIdName
     * @return \StructType\LPhone
     */
    public function setMobilityUserIdName(\StructType\XFkType $mobilityUserIdName = null)
    {
        $this->mobilityUserIdName = $mobilityUserIdName;
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return string|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @uses \EnumType\XPhonePersonalization::valueIsValid()
     * @uses \EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneSuite
     * @return \StructType\LPhone
     */
    public function setPhoneSuite($phoneSuite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhonePersonalization::valueIsValid($phoneSuite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneSuite, implode(', ', \EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses \EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return \StructType\LPhone
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceDisplay, implode(', ', \EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get isProtected value
     * @return string|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param string $isProtected
     * @return \StructType\LPhone
     */
    public function setIsProtected($isProtected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isProtected) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isProtected, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isProtected) && !is_string($isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isProtected)), __LINE__);
        }
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \StructType\LPhone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return string|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @uses \EnumType\XSIPCodec::valueIsValid()
     * @uses \EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferedCodec
     * @return \StructType\LPhone
     */
    public function setMtpPreferedCodec($mtpPreferedCodec = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPCodec::valueIsValid($mtpPreferedCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferedCodec, implode(', ', \EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * @return \StructType\XFkType|null
     */
    public function getDialRulesName()
    {
        return $this->dialRulesName;
    }
    /**
     * Set dialRulesName value
     * @param \StructType\XFkType $dialRulesName
     * @return \StructType\LPhone
     */
    public function setDialRulesName(\StructType\XFkType $dialRulesName = null)
    {
        $this->dialRulesName = $dialRulesName;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \StructType\LPhone
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshUserId) && strlen($sshUserId) > 50) || (is_array($sshUserId) && count($sshUserId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($sshUserId) ? strlen($sshUserId) : count($sshUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get digestUser value
     * @return string|null
     */
    public function getDigestUser()
    {
        return $this->digestUser;
    }
    /**
     * Set digestUser value
     * @param string $digestUser
     * @return \StructType\LPhone
     */
    public function setDigestUser($digestUser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($digestUser) && strlen($digestUser) > 255) || (is_array($digestUser) && count($digestUser) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($digestUser) ? strlen($digestUser) : count($digestUser)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digestUser) && !is_string($digestUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestUser)), __LINE__);
        }
        $this->digestUser = $digestUser;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses \EnumType\XOutboundCallRollover::valueIsValid()
     * @uses \EnumType\XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return \StructType\LPhone
     */
    public function setOutboundCallRollover($outboundCallRollover = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', \EnumType\XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \StructType\LPhone
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \StructType\LPhone
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureInformationUrl) && strlen($secureInformationUrl) > 255) || (is_array($secureInformationUrl) && count($secureInformationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureInformationUrl) ? strlen($secureInformationUrl) : count($secureInformationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureDirectoryUrl value
     * @return string|null
     */
    public function getSecureDirectoryUrl()
    {
        return $this->secureDirectoryUrl;
    }
    /**
     * Set secureDirectoryUrl value
     * @param string $secureDirectoryUrl
     * @return \StructType\LPhone
     */
    public function setSecureDirectoryUrl($secureDirectoryUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureDirectoryUrl) && strlen($secureDirectoryUrl) > 255) || (is_array($secureDirectoryUrl) && count($secureDirectoryUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureDirectoryUrl) ? strlen($secureDirectoryUrl) : count($secureDirectoryUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureDirectoryUrl) && !is_string($secureDirectoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirectoryUrl)), __LINE__);
        }
        $this->secureDirectoryUrl = $secureDirectoryUrl;
        return $this;
    }
    /**
     * Get secureMessageUrl value
     * @return string|null
     */
    public function getSecureMessageUrl()
    {
        return $this->secureMessageUrl;
    }
    /**
     * Set secureMessageUrl value
     * @param string $secureMessageUrl
     * @return \StructType\LPhone
     */
    public function setSecureMessageUrl($secureMessageUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureMessageUrl) && strlen($secureMessageUrl) > 255) || (is_array($secureMessageUrl) && count($secureMessageUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureMessageUrl) ? strlen($secureMessageUrl) : count($secureMessageUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureMessageUrl) && !is_string($secureMessageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessageUrl)), __LINE__);
        }
        $this->secureMessageUrl = $secureMessageUrl;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \StructType\LPhone
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureServicesUrl) && strlen($secureServicesUrl) > 255) || (is_array($secureServicesUrl) && count($secureServicesUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureServicesUrl) ? strlen($secureServicesUrl) : count($secureServicesUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \StructType\LPhone
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureAuthenticationUrl) && strlen($secureAuthenticationUrl) > 255) || (is_array($secureAuthenticationUrl) && count($secureAuthenticationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureAuthenticationUrl) ? strlen($secureAuthenticationUrl) : count($secureAuthenticationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \StructType\LPhone
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureIdleUrl) && strlen($secureIdleUrl) > 255) || (is_array($secureIdleUrl) && count($secureIdleUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureIdleUrl) ? strlen($secureIdleUrl) : count($secureIdleUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \StructType\LPhone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\LPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\XFkType $featureControlPolicy
     * @return \StructType\LPhone
     */
    public function setFeatureControlPolicy(\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return string|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @uses \EnumType\XDeviceTrustMode::valueIsValid()
     * @uses \EnumType\XDeviceTrustMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceTrustMode
     * @return \StructType\LPhone
     */
    public function setDeviceTrustMode($deviceTrustMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceTrustMode::valueIsValid($deviceTrustMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceTrustMode, implode(', ', \EnumType\XDeviceTrustMode::getValidValues())), __LINE__);
        }
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return \StructType\LPhone
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($earlyOfferSupportForVoiceCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($earlyOfferSupportForVoiceCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($earlyOfferSupportForVoiceCall) && !is_string($earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earlyOfferSupportForVoiceCall)), __LINE__);
        }
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get requireThirdPartyRegistration value
     * @return string|null
     */
    public function getRequireThirdPartyRegistration()
    {
        return $this->requireThirdPartyRegistration;
    }
    /**
     * Set requireThirdPartyRegistration value
     * @param string $requireThirdPartyRegistration
     * @return \StructType\LPhone
     */
    public function setRequireThirdPartyRegistration($requireThirdPartyRegistration = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireThirdPartyRegistration) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireThirdPartyRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireThirdPartyRegistration, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireThirdPartyRegistration) && !is_string($requireThirdPartyRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireThirdPartyRegistration)), __LINE__);
        }
        $this->requireThirdPartyRegistration = $requireThirdPartyRegistration;
        return $this;
    }
    /**
     * Get blockIncomingCallsWhenRoaming value
     * @return string|null
     */
    public function getBlockIncomingCallsWhenRoaming()
    {
        return $this->blockIncomingCallsWhenRoaming;
    }
    /**
     * Set blockIncomingCallsWhenRoaming value
     * @param string $blockIncomingCallsWhenRoaming
     * @return \StructType\LPhone
     */
    public function setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blockIncomingCallsWhenRoaming) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockIncomingCallsWhenRoaming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($blockIncomingCallsWhenRoaming, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blockIncomingCallsWhenRoaming) && !is_string($blockIncomingCallsWhenRoaming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockIncomingCallsWhenRoaming)), __LINE__);
        }
        $this->blockIncomingCallsWhenRoaming = $blockIncomingCallsWhenRoaming;
        return $this;
    }
    /**
     * Get homeNetworkId value
     * @return string|null
     */
    public function getHomeNetworkId()
    {
        return $this->homeNetworkId;
    }
    /**
     * Set homeNetworkId value
     * @param string $homeNetworkId
     * @return \StructType\LPhone
     */
    public function setHomeNetworkId($homeNetworkId = null)
    {
        // validation for constraint: string
        if (!is_null($homeNetworkId) && !is_string($homeNetworkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeNetworkId)), __LINE__);
        }
        $this->homeNetworkId = $homeNetworkId;
        return $this;
    }
    /**
     * Get AllowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->AllowPresentationSharingUsingBfcp;
    }
    /**
     * Set AllowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \StructType\LPhone
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowPresentationSharingUsingBfcp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowPresentationSharingUsingBfcp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowPresentationSharingUsingBfcp) && !is_string($allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowPresentationSharingUsingBfcp)), __LINE__);
        }
        $this->AllowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\LPhone
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return \StructType\LPhone
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireOffPremiseLocation)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get allowiXApplicableMedia value
     * @return string|null
     */
    public function getAllowiXApplicableMedia()
    {
        return $this->allowiXApplicableMedia;
    }
    /**
     * Set allowiXApplicableMedia value
     * @param string $allowiXApplicableMedia
     * @return \StructType\LPhone
     */
    public function setAllowiXApplicableMedia($allowiXApplicableMedia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowiXApplicableMedia) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowiXApplicableMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowiXApplicableMedia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowiXApplicableMedia) && !is_string($allowiXApplicableMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowiXApplicableMedia)), __LINE__);
        }
        $this->allowiXApplicableMedia = $allowiXApplicableMedia;
        return $this;
    }
    /**
     * Get enableCallRoutingToRdWhenNoneIsActive value
     * @return string|null
     */
    public function getEnableCallRoutingToRdWhenNoneIsActive()
    {
        return $this->enableCallRoutingToRdWhenNoneIsActive;
    }
    /**
     * Set enableCallRoutingToRdWhenNoneIsActive value
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @return \StructType\LPhone
     */
    public function setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCallRoutingToRdWhenNoneIsActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCallRoutingToRdWhenNoneIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCallRoutingToRdWhenNoneIsActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCallRoutingToRdWhenNoneIsActive) && !is_string($enableCallRoutingToRdWhenNoneIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCallRoutingToRdWhenNoneIsActive)), __LINE__);
        }
        $this->enableCallRoutingToRdWhenNoneIsActive = $enableCallRoutingToRdWhenNoneIsActive;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\LPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LPhone
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
