<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLdapDirectory StructType
 * @subpackage Structs
 */
class LLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ldapDn;
    /**
     * The userSearchBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $nextExecTime;
    /**
     * The accessControlGroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLdapDirectory
     * @uses LLdapDirectory::setName()
     * @uses LLdapDirectory::setLdapDn()
     * @uses LLdapDirectory::setUserSearchBase()
     * @uses LLdapDirectory::setRepeatable()
     * @uses LLdapDirectory::setIntervalValue()
     * @uses LLdapDirectory::setScheduleUnit()
     * @uses LLdapDirectory::setNextExecTime()
     * @uses LLdapDirectory::setAccessControlGroupInfo()
     * @uses LLdapDirectory::setUuid()
     * @param string $name
     * @param string $ldapDn
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param string $uuid
     */
    public function __construct($name = null, $ldapDn = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = null, $nextExecTime = null, \StructType\AccessControlGroupInfo $accessControlGroupInfo = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LLdapDirectory
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \StructType\LLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapDn) && strlen($ldapDn) > 128) || (is_array($ldapDn) && count($ldapDn) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapDn) ? strlen($ldapDn) : count($ldapDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \StructType\LLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userSearchBase) && strlen($userSearchBase) > 255) || (is_array($userSearchBase) && count($userSearchBase) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($userSearchBase) ? strlen($userSearchBase) : count($userSearchBase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \StructType\LLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeatable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeatable)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string|null
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return \StructType\LLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intervalValue, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses \EnumType\XScheduleUnit::valueIsValid()
     * @uses \EnumType\XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return \StructType\LLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduleUnit, implode(', ', \EnumType\XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \StructType\LLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nextExecTime) && strlen($nextExecTime) > 32) || (is_array($nextExecTime) && count($nextExecTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($nextExecTime) ? strlen($nextExecTime) : count($nextExecTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \StructType\LLdapDirectory
     */
    public function setAccessControlGroupInfo(\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LLdapDirectory
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LLdapDirectory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
