<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LHuntPilot StructType
 * @subpackage Structs
 */
class LHuntPilot extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The provideOutsideDialtone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The huntListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $huntListName;
    /**
     * The parkMonForwardNoRetrieve
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParkMonForwardNoRetrieve
     */
    public $parkMonForwardNoRetrieve;
    /**
     * The alertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The forwardHuntNoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ForwardHuntNoAnswer
     */
    public $forwardHuntNoAnswer;
    /**
     * The forwardHuntBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ForwardHuntBusy
     */
    public $forwardHuntBusy;
    /**
     * The callPickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The maxHuntduration
     * Meta informations extracted from the WSDL
     * - documentation: Value "-1" in the response means no value has been assigned and internally the CM will use default setting i.e., 1800s.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxHuntduration;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The displayConnectedNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayConnectedNumber;
    /**
     * The queueCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LCallsQueue
     */
    public $queueCalls;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LHuntPilot
     * @uses LHuntPilot::setPattern()
     * @uses LHuntPilot::setDescription()
     * @uses LHuntPilot::setUsage()
     * @uses LHuntPilot::setRoutePartitionName()
     * @uses LHuntPilot::setBlockEnable()
     * @uses LHuntPilot::setCalledPartyTransformationMask()
     * @uses LHuntPilot::setCallingPartyTransformationMask()
     * @uses LHuntPilot::setUseCallingPartyPhoneMask()
     * @uses LHuntPilot::setCallingPartyPrefixDigits()
     * @uses LHuntPilot::setDialPlanName()
     * @uses LHuntPilot::setDigitDiscardInstructionName()
     * @uses LHuntPilot::setPatternUrgency()
     * @uses LHuntPilot::setPrefixDigitsOut()
     * @uses LHuntPilot::setRouteFilterName()
     * @uses LHuntPilot::setCallingLinePresentationBit()
     * @uses LHuntPilot::setCallingNamePresentationBit()
     * @uses LHuntPilot::setConnectedLinePresentationBit()
     * @uses LHuntPilot::setConnectedNamePresentationBit()
     * @uses LHuntPilot::setPatternPrecedence()
     * @uses LHuntPilot::setProvideOutsideDialtone()
     * @uses LHuntPilot::setCallingPartyNumberingPlan()
     * @uses LHuntPilot::setCallingPartyNumberType()
     * @uses LHuntPilot::setCalledPartyNumberingPlan()
     * @uses LHuntPilot::setCalledPartyNumberType()
     * @uses LHuntPilot::setHuntListName()
     * @uses LHuntPilot::setParkMonForwardNoRetrieve()
     * @uses LHuntPilot::setAlertingName()
     * @uses LHuntPilot::setAsciiAlertingName()
     * @uses LHuntPilot::setAarNeighborhoodName()
     * @uses LHuntPilot::setForwardHuntNoAnswer()
     * @uses LHuntPilot::setForwardHuntBusy()
     * @uses LHuntPilot::setCallPickupGroupName()
     * @uses LHuntPilot::setMaxHuntduration()
     * @uses LHuntPilot::setReleaseClause()
     * @uses LHuntPilot::setDisplayConnectedNumber()
     * @uses LHuntPilot::setQueueCalls()
     * @uses LHuntPilot::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param \StructType\XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param \StructType\XFkType $dialPlanName
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param \StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $patternPrecedence
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param \StructType\XFkType $huntListName
     * @param \StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @param \StructType\ForwardHuntBusy $forwardHuntBusy
     * @param \StructType\XFkType $callPickupGroupName
     * @param string $maxHuntduration
     * @param string $releaseClause
     * @param string $displayConnectedNumber
     * @param \StructType\LCallsQueue $queueCalls
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, \StructType\XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, \StructType\XFkType $dialPlanName = null, \StructType\XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $prefixDigitsOut = null, \StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $patternPrecedence = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, \StructType\XFkType $huntListName = null, \StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null, $alertingName = null, $asciiAlertingName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null, \StructType\ForwardHuntBusy $forwardHuntBusy = null, \StructType\XFkType $callPickupGroupName = null, $maxHuntduration = null, $releaseClause = null, $displayConnectedNumber = null, \StructType\LCallsQueue $queueCalls = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setHuntListName($huntListName)
            ->setParkMonForwardNoRetrieve($parkMonForwardNoRetrieve)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setForwardHuntNoAnswer($forwardHuntNoAnswer)
            ->setForwardHuntBusy($forwardHuntBusy)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setMaxHuntduration($maxHuntduration)
            ->setReleaseClause($releaseClause)
            ->setDisplayConnectedNumber($displayConnectedNumber)
            ->setQueueCalls($queueCalls)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\LHuntPilot
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LHuntPilot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses \EnumType\XPatternUsage::valueIsValid()
     * @uses \EnumType\XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \StructType\LHuntPilot
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', \EnumType\XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\LHuntPilot
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \StructType\LHuntPilot
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($blockEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockEnable)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return \StructType\LHuntPilot
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return \StructType\LHuntPilot
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return \StructType\LHuntPilot
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useCallingPartyPhoneMask, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return \StructType\LHuntPilot
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyPrefixDigits) && strlen($callingPartyPrefixDigits) > 50) || (is_array($callingPartyPrefixDigits) && count($callingPartyPrefixDigits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyPrefixDigits) ? strlen($callingPartyPrefixDigits) : count($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\XFkType $dialPlanName
     * @return \StructType\LHuntPilot
     */
    public function setDialPlanName(\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @return \StructType\LHuntPilot
     */
    public function setDigitDiscardInstructionName(\StructType\XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return \StructType\LHuntPilot
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($patternUrgency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patternUrgency)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return \StructType\LHuntPilot
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \StructType\XFkType $routeFilterName
     * @return \StructType\LHuntPilot
     */
    public function setRouteFilterName(\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return \StructType\LHuntPilot
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLinePresentationBit, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return \StructType\LHuntPilot
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingNamePresentationBit, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return \StructType\LHuntPilot
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedLinePresentationBit, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return \StructType\LHuntPilot
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentationBit, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \EnumType\XPatternPrecedence::valueIsValid()
     * @uses \EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \StructType\LHuntPilot
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', \EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return \StructType\LHuntPilot
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        // validation for constraint: pattern
        if (is_scalar($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provideOutsideDialtone)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \StructType\LHuntPilot
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \StructType\LHuntPilot
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \StructType\LHuntPilot
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \StructType\LHuntPilot
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get huntListName value
     * @return \StructType\XFkType|null
     */
    public function getHuntListName()
    {
        return $this->huntListName;
    }
    /**
     * Set huntListName value
     * @param \StructType\XFkType $huntListName
     * @return \StructType\LHuntPilot
     */
    public function setHuntListName(\StructType\XFkType $huntListName = null)
    {
        $this->huntListName = $huntListName;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieve value
     * @return \StructType\ParkMonForwardNoRetrieve|null
     */
    public function getParkMonForwardNoRetrieve()
    {
        return $this->parkMonForwardNoRetrieve;
    }
    /**
     * Set parkMonForwardNoRetrieve value
     * @param \StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve
     * @return \StructType\LHuntPilot
     */
    public function setParkMonForwardNoRetrieve(\StructType\ParkMonForwardNoRetrieve $parkMonForwardNoRetrieve = null)
    {
        $this->parkMonForwardNoRetrieve = $parkMonForwardNoRetrieve;
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \StructType\LHuntPilot
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertingName) && strlen($alertingName) > 50) || (is_array($alertingName) && count($alertingName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($alertingName) ? strlen($alertingName) : count($alertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \StructType\LHuntPilot
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiAlertingName) && strlen($asciiAlertingName) > 32) || (is_array($asciiAlertingName) && count($asciiAlertingName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($asciiAlertingName) ? strlen($asciiAlertingName) : count($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\LHuntPilot
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get forwardHuntNoAnswer value
     * @return \StructType\ForwardHuntNoAnswer|null
     */
    public function getForwardHuntNoAnswer()
    {
        return $this->forwardHuntNoAnswer;
    }
    /**
     * Set forwardHuntNoAnswer value
     * @param \StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer
     * @return \StructType\LHuntPilot
     */
    public function setForwardHuntNoAnswer(\StructType\ForwardHuntNoAnswer $forwardHuntNoAnswer = null)
    {
        $this->forwardHuntNoAnswer = $forwardHuntNoAnswer;
        return $this;
    }
    /**
     * Get forwardHuntBusy value
     * @return \StructType\ForwardHuntBusy|null
     */
    public function getForwardHuntBusy()
    {
        return $this->forwardHuntBusy;
    }
    /**
     * Set forwardHuntBusy value
     * @param \StructType\ForwardHuntBusy $forwardHuntBusy
     * @return \StructType\LHuntPilot
     */
    public function setForwardHuntBusy(\StructType\ForwardHuntBusy $forwardHuntBusy = null)
    {
        $this->forwardHuntBusy = $forwardHuntBusy;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \StructType\XFkType $callPickupGroupName
     * @return \StructType\LHuntPilot
     */
    public function setCallPickupGroupName(\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get maxHuntduration value
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return $this->maxHuntduration;
    }
    /**
     * Set maxHuntduration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHuntduration
     * @return \StructType\LHuntPilot
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxHuntduration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxHuntduration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxHuntduration = $maxHuntduration;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \StructType\LHuntPilot
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseClause, implode(', ', \EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get displayConnectedNumber value
     * @return string|null
     */
    public function getDisplayConnectedNumber()
    {
        return $this->displayConnectedNumber;
    }
    /**
     * Set displayConnectedNumber value
     * @param string $displayConnectedNumber
     * @return \StructType\LHuntPilot
     */
    public function setDisplayConnectedNumber($displayConnectedNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($displayConnectedNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayConnectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($displayConnectedNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayConnectedNumber) && !is_string($displayConnectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayConnectedNumber)), __LINE__);
        }
        $this->displayConnectedNumber = $displayConnectedNumber;
        return $this;
    }
    /**
     * Get queueCalls value
     * @return \StructType\LCallsQueue|null
     */
    public function getQueueCalls()
    {
        return $this->queueCalls;
    }
    /**
     * Set queueCalls value
     * @param \StructType\LCallsQueue $queueCalls
     * @return \StructType\LHuntPilot
     */
    public function setQueueCalls(\StructType\LCallsQueue $queueCalls = null)
    {
        $this->queueCalls = $queueCalls;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LHuntPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LHuntPilot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
