<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDeviceProfile StructType
 * @subpackage Structs
 */
class LDeviceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $defaultProfileName;
    /**
     * The currentProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $currentProfileName;
    /**
     * The loginTime
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginTime;
    /**
     * The loginDuration
     * Meta informations extracted from the WSDL
     * - documentation: Read-only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginDuration;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $loginUserId;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The currentConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentConfig
     */
    public $currentConfig;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDeviceProfile
     * @uses LDeviceProfile::setName()
     * @uses LDeviceProfile::setDescription()
     * @uses LDeviceProfile::setProduct()
     * @uses LDeviceProfile::setModel()
     * @uses LDeviceProfile::setClass()
     * @uses LDeviceProfile::setProtocol()
     * @uses LDeviceProfile::setProtocolSide()
     * @uses LDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses LDeviceProfile::setTraceFlag()
     * @uses LDeviceProfile::setMlppIndicationStatus()
     * @uses LDeviceProfile::setPreemption()
     * @uses LDeviceProfile::setPhoneTemplateName()
     * @uses LDeviceProfile::setUserLocale()
     * @uses LDeviceProfile::setDefaultProfileName()
     * @uses LDeviceProfile::setCurrentProfileName()
     * @uses LDeviceProfile::setLoginTime()
     * @uses LDeviceProfile::setLoginDuration()
     * @uses LDeviceProfile::setSingleButtonBarge()
     * @uses LDeviceProfile::setJoinAcrossLines()
     * @uses LDeviceProfile::setLoginUserId()
     * @uses LDeviceProfile::setIgnorePresentationIndicators()
     * @uses LDeviceProfile::setDndOption()
     * @uses LDeviceProfile::setDndRingSetting()
     * @uses LDeviceProfile::setDndStatus()
     * @uses LDeviceProfile::setEmccCallingSearchSpace()
     * @uses LDeviceProfile::setAlwaysUsePrimeLine()
     * @uses LDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LDeviceProfile::setSoftkeyTemplateName()
     * @uses LDeviceProfile::setCallInfoPrivacyStatus()
     * @uses LDeviceProfile::setCurrentConfig()
     * @uses LDeviceProfile::setFeatureControlPolicy()
     * @uses LDeviceProfile::setCtiid()
     * @uses LDeviceProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param string $userHoldMohAudioSourceId
     * @param string $traceFlag
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param \StructType\XFkType $phoneTemplateName
     * @param string $userLocale
     * @param string $defaultProfileName
     * @param \StructType\XFkType $currentProfileName
     * @param string $loginTime
     * @param string $loginDuration
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \StructType\XFkType $loginUserId
     * @param string $ignorePresentationIndicators
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param \StructType\XFkType $emccCallingSearchSpace
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\XFkType $softkeyTemplateName
     * @param string $callInfoPrivacyStatus
     * @param \StructType\CurrentConfig $currentConfig
     * @param \StructType\XFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, $userHoldMohAudioSourceId = null, $traceFlag = null, $mlppIndicationStatus = null, $preemption = null, \StructType\XFkType $phoneTemplateName = null, $userLocale = null, $defaultProfileName = null, \StructType\XFkType $currentProfileName = null, $loginTime = null, $loginDuration = null, $singleButtonBarge = null, $joinAcrossLines = null, \StructType\XFkType $loginUserId = null, $ignorePresentationIndicators = null, $dndOption = null, $dndRingSetting = null, $dndStatus = null, \StructType\XFkType $emccCallingSearchSpace = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \StructType\XFkType $softkeyTemplateName = null, $callInfoPrivacyStatus = null, \StructType\CurrentConfig $currentConfig = null, \StructType\XFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setTraceFlag($traceFlag)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setUserLocale($userLocale)
            ->setDefaultProfileName($defaultProfileName)
            ->setCurrentProfileName($currentProfileName)
            ->setLoginTime($loginTime)
            ->setLoginDuration($loginDuration)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setCurrentConfig($currentConfig)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LDeviceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LDeviceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\LDeviceProfile
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \StructType\LDeviceProfile
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\LDeviceProfile
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\LDeviceProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\LDeviceProfile
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \StructType\LDeviceProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\LDeviceProfile
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\LDeviceProfile
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\LDeviceProfile
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\XFkType $phoneTemplateName
     * @return \StructType\LDeviceProfile
     */
    public function setPhoneTemplateName(\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\LDeviceProfile
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return string|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param string $defaultProfileName
     * @return \StructType\LDeviceProfile
     */
    public function setDefaultProfileName($defaultProfileName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($defaultProfileName) && strlen($defaultProfileName) > 50) || (is_array($defaultProfileName) && count($defaultProfileName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($defaultProfileName) ? strlen($defaultProfileName) : count($defaultProfileName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($defaultProfileName) && !is_string($defaultProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultProfileName)), __LINE__);
        }
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get currentProfileName value
     * @return \StructType\XFkType|null
     */
    public function getCurrentProfileName()
    {
        return $this->currentProfileName;
    }
    /**
     * Set currentProfileName value
     * @param \StructType\XFkType $currentProfileName
     * @return \StructType\LDeviceProfile
     */
    public function setCurrentProfileName(\StructType\XFkType $currentProfileName = null)
    {
        $this->currentProfileName = $currentProfileName;
        return $this;
    }
    /**
     * Get loginTime value
     * @return string|null
     */
    public function getLoginTime()
    {
        return $this->loginTime;
    }
    /**
     * Set loginTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginTime
     * @return \StructType\LDeviceProfile
     */
    public function setLoginTime($loginTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($loginTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginTime = $loginTime;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return string|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginDuration
     * @return \StructType\LDeviceProfile
     */
    public function setLoginDuration($loginDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($loginDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\LDeviceProfile
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\LDeviceProfile
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return \StructType\XFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param \StructType\XFkType $loginUserId
     * @return \StructType\LDeviceProfile
     */
    public function setLoginUserId(\StructType\XFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \StructType\LDeviceProfile
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \EnumType\XDNDOption::valueIsValid()
     * @uses \EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \StructType\LDeviceProfile
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \StructType\LDeviceProfile
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \StructType\LDeviceProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return \StructType\XFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param \StructType\XFkType $emccCallingSearchSpace
     * @return \StructType\LDeviceProfile
     */
    public function setEmccCallingSearchSpace(\StructType\XFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \StructType\LDeviceProfile
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\LDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\XFkType $softkeyTemplateName
     * @return \StructType\LDeviceProfile
     */
    public function setSoftkeyTemplateName(\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \StructType\LDeviceProfile
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get currentConfig value
     * @return \StructType\CurrentConfig|null
     */
    public function getCurrentConfig()
    {
        return $this->currentConfig;
    }
    /**
     * Set currentConfig value
     * @param \StructType\CurrentConfig $currentConfig
     * @return \StructType\LDeviceProfile
     */
    public function setCurrentConfig(\StructType\CurrentConfig $currentConfig = null)
    {
        $this->currentConfig = $currentConfig;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\XFkType $featureControlPolicy
     * @return \StructType\LDeviceProfile
     */
    public function setFeatureControlPolicy(\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\LDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
