<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LConferenceNow StructType
 * @subpackage Structs
 */
class LConferenceNow extends AbstractStructBase
{
    /**
     * The conferenceNowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conferenceNowNumber;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The maxWaitTimeForHost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxWaitTimeForHost;
    /**
     * The MohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MohAudioSourceId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LConferenceNow
     * @uses LConferenceNow::setConferenceNowNumber()
     * @uses LConferenceNow::setRoutePartitionName()
     * @uses LConferenceNow::setDescription()
     * @uses LConferenceNow::setMaxWaitTimeForHost()
     * @uses LConferenceNow::setMohAudioSourceId()
     * @uses LConferenceNow::setUuid()
     * @param string $conferenceNowNumber
     * @param \StructType\XFkType $routePartitionName
     * @param string $description
     * @param string $maxWaitTimeForHost
     * @param string $mohAudioSourceId
     * @param string $uuid
     */
    public function __construct($conferenceNowNumber = null, \StructType\XFkType $routePartitionName = null, $description = null, $maxWaitTimeForHost = null, $mohAudioSourceId = null, $uuid = null)
    {
        $this
            ->setConferenceNowNumber($conferenceNowNumber)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setMaxWaitTimeForHost($maxWaitTimeForHost)
            ->setMohAudioSourceId($mohAudioSourceId)
            ->setUuid($uuid);
    }
    /**
     * Get conferenceNowNumber value
     * @return string|null
     */
    public function getConferenceNowNumber()
    {
        return $this->conferenceNowNumber;
    }
    /**
     * Set conferenceNowNumber value
     * @param string $conferenceNowNumber
     * @return \StructType\LConferenceNow
     */
    public function setConferenceNowNumber($conferenceNowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceNowNumber) && !is_string($conferenceNowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceNowNumber)), __LINE__);
        }
        $this->conferenceNowNumber = $conferenceNowNumber;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\LConferenceNow
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LConferenceNow
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get maxWaitTimeForHost value
     * @return string|null
     */
    public function getMaxWaitTimeForHost()
    {
        return $this->maxWaitTimeForHost;
    }
    /**
     * Set maxWaitTimeForHost value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeForHost
     * @return \StructType\LConferenceNow
     */
    public function setMaxWaitTimeForHost($maxWaitTimeForHost = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxWaitTimeForHost)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxWaitTimeForHost, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeForHost = $maxWaitTimeForHost;
        return $this;
    }
    /**
     * Get MohAudioSourceId value
     * @return string|null
     */
    public function getMohAudioSourceId()
    {
        return $this->MohAudioSourceId;
    }
    /**
     * Set MohAudioSourceId value
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohAudioSourceId
     * @return \StructType\LConferenceNow
     */
    public function setMohAudioSourceId($mohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($mohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->MohAudioSourceId = $mohAudioSourceId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LConferenceNow
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LConferenceNow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
