<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallerFilterListMember StructType
 * @subpackage Structs
 */
class LCallerFilterListMember extends AbstractStructBase
{
    /**
     * The DnMask
     * Meta informations extracted from the WSDL
     * - documentation: Mandatory when "callerFilterMask" has value as Directory Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $DnMask;
    /**
     * The callerFilterMask
     * Meta informations extracted from the WSDL
     * - documentation: Mandatory when value is a directory number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerFilterMask;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCallerFilterListMember
     * @uses LCallerFilterListMember::setDnMask()
     * @uses LCallerFilterListMember::setCallerFilterMask()
     * @uses LCallerFilterListMember::setUuid()
     * @param string $dnMask
     * @param string $callerFilterMask
     * @param string $uuid
     */
    public function __construct($dnMask = null, $callerFilterMask = null, $uuid = null)
    {
        $this
            ->setDnMask($dnMask)
            ->setCallerFilterMask($callerFilterMask)
            ->setUuid($uuid);
    }
    /**
     * Get DnMask value
     * @return string|null
     */
    public function getDnMask()
    {
        return $this->DnMask;
    }
    /**
     * Set DnMask value
     * @param string $dnMask
     * @return \StructType\LCallerFilterListMember
     */
    public function setDnMask($dnMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dnMask) && strlen($dnMask) > 50) || (is_array($dnMask) && count($dnMask) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($dnMask) ? strlen($dnMask) : count($dnMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dnMask) && !is_string($dnMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dnMask)), __LINE__);
        }
        $this->DnMask = $dnMask;
        return $this;
    }
    /**
     * Get callerFilterMask value
     * @return string|null
     */
    public function getCallerFilterMask()
    {
        return $this->callerFilterMask;
    }
    /**
     * Set callerFilterMask value
     * @uses \EnumType\XCallerFilterMask::valueIsValid()
     * @uses \EnumType\XCallerFilterMask::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerFilterMask
     * @return \StructType\LCallerFilterListMember
     */
    public function setCallerFilterMask($callerFilterMask = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallerFilterMask::valueIsValid($callerFilterMask)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerFilterMask, implode(', ', \EnumType\XCallerFilterMask::getValidValues())), __LINE__);
        }
        $this->callerFilterMask = $callerFilterMask;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCallerFilterListMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LCallerFilterListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
