<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallerFilterList StructType
 * @subpackage Structs
 */
class LCallerFilterList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The isAllowedType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAllowedType;
    /**
     * The endUserIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $endUserIdName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCallerFilterList
     * @uses LCallerFilterList::setName()
     * @uses LCallerFilterList::setDescription()
     * @uses LCallerFilterList::setIsAllowedType()
     * @uses LCallerFilterList::setEndUserIdName()
     * @uses LCallerFilterList::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isAllowedType
     * @param \StructType\XFkType $endUserIdName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isAllowedType = null, \StructType\XFkType $endUserIdName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsAllowedType($isAllowedType)
            ->setEndUserIdName($endUserIdName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LCallerFilterList
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LCallerFilterList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isAllowedType value
     * @return string|null
     */
    public function getIsAllowedType()
    {
        return $this->isAllowedType;
    }
    /**
     * Set isAllowedType value
     * @param string $isAllowedType
     * @return \StructType\LCallerFilterList
     */
    public function setIsAllowedType($isAllowedType = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isAllowedType) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isAllowedType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isAllowedType) && !is_string($isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAllowedType)), __LINE__);
        }
        $this->isAllowedType = $isAllowedType;
        return $this;
    }
    /**
     * Get endUserIdName value
     * @return \StructType\XFkType|null
     */
    public function getEndUserIdName()
    {
        return $this->endUserIdName;
    }
    /**
     * Set endUserIdName value
     * @param \StructType\XFkType $endUserIdName
     * @return \StructType\LCallerFilterList
     */
    public function setEndUserIdName(\StructType\XFkType $endUserIdName = null)
    {
        $this->endUserIdName = $endUserIdName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCallerFilterList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LCallerFilterList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
