<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LBillingServer StructType
 * @subpackage Structs
 */
class LBillingServer extends AbstractStructBase
{
    /**
     * The hostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostName;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The directory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directory;
    /**
     * The resendOnFailure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * The billingServerProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $billingServerProtocol;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LBillingServer
     * @uses LBillingServer::setHostName()
     * @uses LBillingServer::setUserId()
     * @uses LBillingServer::setPassword()
     * @uses LBillingServer::setDirectory()
     * @uses LBillingServer::setResendOnFailure()
     * @uses LBillingServer::setBillingServerProtocol()
     * @uses LBillingServer::setUuid()
     * @param string $hostName
     * @param string $userId
     * @param string $password
     * @param string $directory
     * @param string $resendOnFailure
     * @param string $billingServerProtocol
     * @param string $uuid
     */
    public function __construct($hostName = null, $userId = null, $password = null, $directory = null, $resendOnFailure = null, $billingServerProtocol = null, $uuid = null)
    {
        $this
            ->setHostName($hostName)
            ->setUserId($userId)
            ->setPassword($password)
            ->setDirectory($directory)
            ->setResendOnFailure($resendOnFailure)
            ->setBillingServerProtocol($billingServerProtocol)
            ->setUuid($uuid);
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \StructType\LBillingServer
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\LBillingServer
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\LBillingServer
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get directory value
     * @return string|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return \StructType\LBillingServer
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \StructType\LBillingServer
     */
    public function setResendOnFailure($resendOnFailure = null)
    {
        // validation for constraint: pattern
        if (is_scalar($resendOnFailure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($resendOnFailure, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resendOnFailure) && !is_string($resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resendOnFailure)), __LINE__);
        }
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string|null
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @uses \EnumType\XBillingserverprotocol::valueIsValid()
     * @uses \EnumType\XBillingserverprotocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingServerProtocol
     * @return \StructType\LBillingServer
     */
    public function setBillingServerProtocol($billingServerProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBillingserverprotocol::valueIsValid($billingServerProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $billingServerProtocol, implode(', ', \EnumType\XBillingserverprotocol::getValidValues())), __LINE__);
        }
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LBillingServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LBillingServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
