<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRoutePatternReq StructType
 * @subpackage Structs
 */
class GetRoutePatternReq extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RRoutePattern
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetRoutePatternReq
     * @uses GetRoutePatternReq::setPattern()
     * @uses GetRoutePatternReq::setRoutePartitionName()
     * @uses GetRoutePatternReq::setDialPlanName()
     * @uses GetRoutePatternReq::setRouteFilterName()
     * @uses GetRoutePatternReq::setUuid()
     * @uses GetRoutePatternReq::setReturnedTags()
     * @uses GetRoutePatternReq::setSequence()
     * @param string $pattern
     * @param \StructType\XFkType $routePartitionName
     * @param \StructType\XFkType $dialPlanName
     * @param \StructType\XFkType $routeFilterName
     * @param string $uuid
     * @param \StructType\RRoutePattern $returnedTags
     * @param int $sequence
     */
    public function __construct($pattern = null, \StructType\XFkType $routePartitionName = null, \StructType\XFkType $dialPlanName = null, \StructType\XFkType $routeFilterName = null, $uuid = null, \StructType\RRoutePattern $returnedTags = null, $sequence = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\GetRoutePatternReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\GetRoutePatternReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\XFkType
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\XFkType $dialPlanName
     * @return \StructType\GetRoutePatternReq
     */
    public function setDialPlanName(\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \StructType\XFkType
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \StructType\XFkType $routeFilterName
     * @return \StructType\GetRoutePatternReq
     */
    public function setRouteFilterName(\StructType\XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\GetRoutePatternReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \StructType\RRoutePattern|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \StructType\RRoutePattern $returnedTags
     * @return \StructType\GetRoutePatternReq
     */
    public function setReturnedTags(\StructType\RRoutePattern $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\GetRoutePatternReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRoutePatternReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
