<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoChangeDNDStatusReq StructType
 * @subpackage Structs
 */
class DoChangeDNDStatusReq extends APIRequest
{
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: True means set dndStatus for device as true, false means set dndStatus for device as false
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The userID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userID;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for DoChangeDNDStatusReq
     * @uses DoChangeDNDStatusReq::setDndStatus()
     * @uses DoChangeDNDStatusReq::setUserID()
     * @uses DoChangeDNDStatusReq::setUuid()
     * @param string $dndStatus
     * @param string $userID
     * @param string $uuid
     */
    public function __construct($dndStatus = null, $userID = null, $uuid = null)
    {
        $this
            ->setDndStatus($dndStatus)
            ->setUserID($userID)
            ->setUuid($uuid);
    }
    /**
     * Get dndStatus value
     * @return string
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \StructType\DoChangeDNDStatusReq
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\DoChangeDNDStatusReq
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\DoChangeDNDStatusReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoChangeDNDStatusReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
