<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for directedCallParkDnAndPartition StructType
 * @subpackage Structs
 */
class DirectedCallParkDnAndPartition extends AbstractStructBase
{
    /**
     * The dnPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 255
     * @var string
     */
    public $dnPattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * Constructor method for directedCallParkDnAndPartition
     * @uses DirectedCallParkDnAndPartition::setDnPattern()
     * @uses DirectedCallParkDnAndPartition::setRoutePartitionName()
     * @param string $dnPattern
     * @param \StructType\XFkType $routePartitionName
     */
    public function __construct($dnPattern = null, \StructType\XFkType $routePartitionName = null)
    {
        $this
            ->setDnPattern($dnPattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get dnPattern value
     * @return string
     */
    public function getDnPattern()
    {
        return $this->dnPattern;
    }
    /**
     * Set dnPattern value
     * @param string $dnPattern
     * @return \StructType\DirectedCallParkDnAndPartition
     */
    public function setDnPattern($dnPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dnPattern) && strlen($dnPattern) > 255) || (is_array($dnPattern) && count($dnPattern) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dnPattern) ? strlen($dnPattern) : count($dnPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dnPattern) && !is_string($dnPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dnPattern)), __LINE__);
        }
        $this->dnPattern = $dnPattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\DirectedCallParkDnAndPartition
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectedCallParkDnAndPartition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
