<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedDevices StructType
 * Meta informations extracted from the WSDL
 * - documentation: Also known as controlled devices. | Also known as controlled devices. | Also known as controlled devices. | Also known as controlled devices. | Read only | Also known as controlled devices. | Also known as controlled devices. | Read
 * only
 * @subpackage Structs
 */
class AssociatedDevices extends AbstractStructBase
{
    /**
     * The device
     * Meta informations extracted from the WSDL
     * - documentation: Name of device. | Name of device. | Name of device. | Name of device. | Name of device. | Name of device.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $device;
    /**
     * Constructor method for associatedDevices
     * @uses AssociatedDevices::setDevice()
     * @param string[] $device
     */
    public function __construct(array $device = array())
    {
        $this
            ->setDevice($device);
    }
    /**
     * Get device value
     * @return string[]|null
     */
    public function getDevice()
    {
        return $this->device;
    }
    /**
     * Set device value
     * @throws \InvalidArgumentException
     * @param string[] $device
     * @return \StructType\AssociatedDevices
     */
    public function setDevice(array $device = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($device) && strlen($device) > 50) || (is_array($device) && count($device) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($device) ? strlen($device) : count($device)), __LINE__);
        }
        foreach ($device as $associatedDevicesDeviceItem) {
            // validation for constraint: itemType
            if (!is_string($associatedDevicesDeviceItem)) {
                throw new \InvalidArgumentException(sprintf('The device property can only contain items of string, "%s" given', is_object($associatedDevicesDeviceItem) ? get_class($associatedDevicesDeviceItem) : gettype($associatedDevicesDeviceItem)), __LINE__);
            }
        }
        $this->device = $device;
        return $this;
    }
    /**
     * Add item to device value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AssociatedDevices
     */
    public function addToDevice($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The device property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->device[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedDevices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
