<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedBlfSdFeatures StructType
 * @subpackage Structs
 */
class AssociatedBlfSdFeatures extends AbstractStructBase
{
    /**
     * The feature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $feature;
    /**
     * Constructor method for associatedBlfSdFeatures
     * @uses AssociatedBlfSdFeatures::setFeature()
     * @param string[] $feature
     */
    public function __construct(array $feature = array())
    {
        $this
            ->setFeature($feature);
    }
    /**
     * Get feature value
     * @return string[]|null
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @uses \EnumType\XBLFSDOption::valueIsValid()
     * @uses \EnumType\XBLFSDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $feature
     * @return \StructType\AssociatedBlfSdFeatures
     */
    public function setFeature(array $feature = array())
    {
        $invalidValues = array();
        foreach ($feature as $associatedBlfSdFeaturesFeatureItem) {
            if (!\EnumType\XBLFSDOption::valueIsValid($associatedBlfSdFeaturesFeatureItem)) {
                $invalidValues[] = var_export($associatedBlfSdFeaturesFeatureItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\XBLFSDOption::getValidValues())), __LINE__);
        }
        $this->feature = $feature;
        return $this;
    }
    /**
     * Add item to feature value
     * @uses \EnumType\XBLFSDOption::valueIsValid()
     * @uses \EnumType\XBLFSDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AssociatedBlfSdFeatures
     */
    public function addToFeature($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBLFSDOption::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\XBLFSDOption::getValidValues())), __LINE__);
        }
        $this->feature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedBlfSdFeatures
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
