<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addRelatedPolicies StructType
 * @subpackage Structs
 */
class AddRelatedPolicies extends XCommonMembersExtension
{
    /**
     * The relatedPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPolicyRelationship[]
     */
    public $relatedPolicy;
    /**
     * Constructor method for addRelatedPolicies
     * @uses AddRelatedPolicies::setRelatedPolicy()
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     */
    public function __construct(array $relatedPolicy = array())
    {
        $this
            ->setRelatedPolicy($relatedPolicy);
    }
    /**
     * Get relatedPolicy value
     * @return \StructType\XPolicyRelationship[]
     */
    public function getRelatedPolicy()
    {
        return $this->relatedPolicy;
    }
    /**
     * Set relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship[] $relatedPolicy
     * @return \StructType\AddRelatedPolicies
     */
    public function setRelatedPolicy(array $relatedPolicy = array())
    {
        foreach ($relatedPolicy as $addRelatedPoliciesRelatedPolicyItem) {
            // validation for constraint: itemType
            if (!$addRelatedPoliciesRelatedPolicyItem instanceof \StructType\XPolicyRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \StructType\XPolicyRelationship, "%s" given', is_object($addRelatedPoliciesRelatedPolicyItem) ? get_class($addRelatedPoliciesRelatedPolicyItem) : gettype($addRelatedPoliciesRelatedPolicyItem)), __LINE__);
            }
        }
        $this->relatedPolicy = $relatedPolicy;
        return $this;
    }
    /**
     * Add item to relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\XPolicyRelationship $item
     * @return \StructType\AddRelatedPolicies
     */
    public function addToRelatedPolicy(\StructType\XPolicyRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPolicyRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \StructType\XPolicyRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedPolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddRelatedPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
