<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addEndUsers StructType
 * @subpackage Structs
 */
class AddEndUsers extends XCommonMembersExtension
{
    /**
     * The selectedEndUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SelectedEndUser[]
     */
    public $selectedEndUser;
    /**
     * Constructor method for addEndUsers
     * @uses AddEndUsers::setSelectedEndUser()
     * @param \StructType\SelectedEndUser[] $selectedEndUser
     */
    public function __construct(array $selectedEndUser = array())
    {
        $this
            ->setSelectedEndUser($selectedEndUser);
    }
    /**
     * Get selectedEndUser value
     * @return \StructType\SelectedEndUser[]
     */
    public function getSelectedEndUser()
    {
        return $this->selectedEndUser;
    }
    /**
     * Set selectedEndUser value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedEndUser[] $selectedEndUser
     * @return \StructType\AddEndUsers
     */
    public function setSelectedEndUser(array $selectedEndUser = array())
    {
        foreach ($selectedEndUser as $addEndUsersSelectedEndUserItem) {
            // validation for constraint: itemType
            if (!$addEndUsersSelectedEndUserItem instanceof \StructType\SelectedEndUser) {
                throw new \InvalidArgumentException(sprintf('The selectedEndUser property can only contain items of \StructType\SelectedEndUser, "%s" given', is_object($addEndUsersSelectedEndUserItem) ? get_class($addEndUsersSelectedEndUserItem) : gettype($addEndUsersSelectedEndUserItem)), __LINE__);
            }
        }
        $this->selectedEndUser = $selectedEndUser;
        return $this;
    }
    /**
     * Add item to selectedEndUser value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedEndUser $item
     * @return \StructType\AddEndUsers
     */
    public function addToSelectedEndUser(\StructType\SelectedEndUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedEndUser) {
            throw new \InvalidArgumentException(sprintf('The selectedEndUser property can only contain items of \StructType\SelectedEndUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->selectedEndUser[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddEndUsers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
