<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addAssociatedTrunks StructType
 * @subpackage Structs
 */
class AddAssociatedTrunks extends XCommonMembersExtension
{
    /**
     * The associatedTrunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XCcdRequestingServiceMember[]
     */
    public $associatedTrunk;
    /**
     * Constructor method for addAssociatedTrunks
     * @uses AddAssociatedTrunks::setAssociatedTrunk()
     * @param \StructType\XCcdRequestingServiceMember[] $associatedTrunk
     */
    public function __construct(array $associatedTrunk = array())
    {
        $this
            ->setAssociatedTrunk($associatedTrunk);
    }
    /**
     * Get associatedTrunk value
     * @return \StructType\XCcdRequestingServiceMember[]
     */
    public function getAssociatedTrunk()
    {
        return $this->associatedTrunk;
    }
    /**
     * Set associatedTrunk value
     * @throws \InvalidArgumentException
     * @param \StructType\XCcdRequestingServiceMember[] $associatedTrunk
     * @return \StructType\AddAssociatedTrunks
     */
    public function setAssociatedTrunk(array $associatedTrunk = array())
    {
        foreach ($associatedTrunk as $addAssociatedTrunksAssociatedTrunkItem) {
            // validation for constraint: itemType
            if (!$addAssociatedTrunksAssociatedTrunkItem instanceof \StructType\XCcdRequestingServiceMember) {
                throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of \StructType\XCcdRequestingServiceMember, "%s" given', is_object($addAssociatedTrunksAssociatedTrunkItem) ? get_class($addAssociatedTrunksAssociatedTrunkItem) : gettype($addAssociatedTrunksAssociatedTrunkItem)), __LINE__);
            }
        }
        $this->associatedTrunk = $associatedTrunk;
        return $this;
    }
    /**
     * Add item to associatedTrunk value
     * @throws \InvalidArgumentException
     * @param \StructType\XCcdRequestingServiceMember $item
     * @return \StructType\AddAssociatedTrunks
     */
    public function addToAssociatedTrunk(\StructType\XCcdRequestingServiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XCcdRequestingServiceMember) {
            throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of \StructType\XCcdRequestingServiceMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associatedTrunk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAssociatedTrunks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
