<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wipe ServiceType
 * @subpackage Services
 */
class Wipe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named wipePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function wipePhone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->wipePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
