<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lock ServiceType
 * @subpackage Services
 */
class Lock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lockPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function lockPhone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->lockPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
