<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipProfile(\StructType\AddSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipTrunkSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipTrunkSecurityProfile(\StructType\AddSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTimePeriodReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTimePeriod(\StructType\AddTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTimeScheduleReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTimeSchedule(\StructType\AddTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTodAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTodAccess(\StructType\AddTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVoiceMailPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVoiceMailPilot(\StructType\AddVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddProcessNodeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addProcessNode(\StructType\AddProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCallerFilterListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCallerFilterList(\StructType\AddCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRoutePartitionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRoutePartition(\StructType\AddRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCssReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCss(\StructType\AddCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMediaResourceGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMediaResourceGroup(\StructType\AddMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMediaResourceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMediaResourceList(\StructType\AddMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRegionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRegion(\StructType\AddRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAarGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAarGroup(\StructType\AddAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPhysicalLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPhysicalLocation(\StructType\AddPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRouteGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRouteGroup(\StructType\AddRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDevicePoolReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDevicePool(\StructType\AddDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDeviceMobilityGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDeviceMobilityGroup(\StructType\AddDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLocation(\StructType\AddLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSoftKeyTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSoftKeyTemplate(\StructType\AddSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTranscoderReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTranscoder(\StructType\AddTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCommonDeviceConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCommonDeviceConfig(\StructType\AddCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddResourcePriorityNamespaceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespace(\StructType\AddResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddResourcePriorityNamespaceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addResourcePriorityNamespaceList(\StructType\AddResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDeviceMobilityReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDeviceMobility(\StructType\AddDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCmcInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCmcInfo(\StructType\AddCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCredentialPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCredentialPolicy(\StructType\AddCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddFacInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addFacInfo(\StructType\AddFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddHuntListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addHuntList(\StructType\AddHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddIvrUserLocaleReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addIvrUserLocale(\StructType\AddIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLineGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLineGroup(\StructType\AddLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRecordingProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRecordingProfile(\StructType\AddRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRouteFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRouteFilter(\StructType\AddRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCallManagerGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCallManagerGroup(\StructType\AddCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUserGroup(\StructType\AddUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDhcpServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDhcpServer(\StructType\AddDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDhcpSubnetReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDhcpSubnet(\StructType\AddDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCallPark(\StructType\AddCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDirectedCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDirectedCallPark(\StructType\AddDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMeetMeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMeetMe(\StructType\AddMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addConferenceNow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddConferenceNowReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addConferenceNow(\StructType\AddConferenceNowReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addConferenceNow($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMobileVoiceAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMobileVoiceAccess(\StructType\AddMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRouteListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRouteList(\StructType\AddRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUser(\StructType\AddUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAppUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAppUser(\StructType\AddAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipRealmReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipRealm(\StructType\AddSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPhoneNtpReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPhoneNtp(\StructType\AddPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDateTimeGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDateTimeGroup(\StructType\AddDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPresenceGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPresenceGroup(\StructType\AddPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGeoLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGeoLocation(\StructType\AddGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSrstReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSrst(\StructType\AddSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMlppDomainReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMlppDomain(\StructType\AddMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCumaServerSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCumaServerSecurityProfile(\StructType\AddCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddApplicationServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addApplicationServer(\StructType\AddApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddApplicationUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addApplicationUserCapfProfile(\StructType\AddApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEndUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addEndUserCapfProfile(\StructType\AddEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserPhoneAssociation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserPhoneAssociationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUserPhoneAssociation(\StructType\AddUserPhoneAssociationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserPhoneAssociation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGeoLocationFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGeoLocationFilter(\StructType\AddGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVoiceMailProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVoiceMailProfile(\StructType\AddVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVoiceMailPortReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVoiceMailPort(\StructType\AddVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatekeeperReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatekeeper(\StructType\AddGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPhoneButtonTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPhoneButtonTemplate(\StructType\AddPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCommonPhoneConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCommonPhoneConfig(\StructType\AddCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMessageWaitingReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMessageWaiting(\StructType\AddMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddIpPhoneServicesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addIpPhoneServices(\StructType\AddIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCtiRoutePointReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCtiRoutePoint(\StructType\AddCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTransPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTransPattern(\StructType\AddTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCallingPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCallingPartyTransformationPattern(\StructType\AddCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipRoutePattern(\StructType\AddSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddHuntPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addHuntPilot(\StructType\AddHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRoutePattern(\StructType\AddRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddApplicationDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addApplicationDialRules(\StructType\AddApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDirectoryLookupDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDirectoryLookupDialRules(\StructType\AddDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPhoneSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPhoneSecurityProfile(\StructType\AddPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipDialRules(\StructType\AddSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddConferenceBridgeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addConferenceBridge(\StructType\AddConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMtpReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMtp(\StructType\AddMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRemoteDestinationProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRemoteDestinationProfile(\StructType\AddRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLineReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLine(\StructType\AddLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDefaultDeviceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDefaultDeviceProfile(\StructType\AddDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddH323PhoneReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addH323Phone(\StructType\AddH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddH323TrunkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addH323Trunk(\StructType\AddH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPhoneReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPhone(\StructType\AddPhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddH323GatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addH323Gateway(\StructType\AddH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDeviceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDeviceProfile(\StructType\AddDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRemoteDestinationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRemoteDestination(\StructType\AddRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVg224Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVg224(\StructType\AddVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGateway(\StructType\AddGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewayEndpointAnalogAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewayEndpointAnalogAccess(\StructType\AddGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessPri(\StructType\AddGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessBri(\StructType\AddGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewayEndpointDigitalAccessT1(\StructType\AddGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst600024PortFXSGateway(\StructType\AddCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000E1VoIPGateway(\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayPri(\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCiscoCatalyst6000T1VoIPGatewayT1(\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCallPickupGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCallPickupGroup(\StructType\AddCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGeoLocationPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGeoLocationPolicy(\StructType\AddGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSipTrunkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSipTrunk(\StructType\AddSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCalledPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCalledPartyTransformationPattern(\StructType\AddCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddExternalCallControlProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addExternalCallControlProfile(\StructType\AddExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSafSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSafSecurityProfile(\StructType\AddSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSafForwarderReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSafForwarder(\StructType\AddSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCcdHostedDNReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCcdHostedDN(\StructType\AddCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCcdHostedDNGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCcdHostedDNGroup(\StructType\AddCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCcdRequestingServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCcdRequestingService(\StructType\AddCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddRemoteClusterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addRemoteCluster(\StructType\AddRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCcdAdvertisingServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCcdAdvertisingService(\StructType\AddCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUnitsToGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUnitsToGateway(\StructType\AddUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewaySubunitsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewaySubunits(\StructType\AddGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLdapDirectoryReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLdapDirectory(\StructType\AddLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSafCcdPurgeBlockLearnedRoutes(\StructType\AddSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVpnGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVpnGateway(\StructType\AddVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVpnGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVpnGroup(\StructType\AddVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVpnProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVpnProfile(\StructType\AddVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeServer(\StructType\AddImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeRouteFilterGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeRouteFilterGroup(\StructType\AddImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeRouteFilterElementReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeRouteFilterElement(\StructType\AddImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeClientReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeClient(\StructType\AddImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeEnrolledPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeEnrolledPattern(\StructType\AddImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeEnrolledPatternGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeEnrolledPatternGroup(\StructType\AddImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeExclusionNumberReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeExclusionNumber(\StructType\AddImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeExclusionNumberGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeExclusionNumberGroup(\StructType\AddImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeFirewallReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeFirewall(\StructType\AddImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImeE164TransformationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImeE164Transformation(\StructType\AddImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTransformationProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addTransformationProfile(\StructType\AddTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddFallbackProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addFallbackProfile(\StructType\AddFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLdapFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLdapFilter(\StructType\AddLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAppServerInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAppServerInfo(\StructType\AddAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddFeatureControlPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addFeatureControlPolicy(\StructType\AddFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMobilityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMobilityProfile(\StructType\AddMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * addEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addEnterpriseFeatureAccessConfiguration(\StructType\AddEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddHandoffConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addHandoffConfiguration(\StructType\AddHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCalledPartyTracing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCalledPartyTracingReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCalledPartyTracing(\StructType\AddCalledPartyTracingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCalledPartyTracing($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSIPNormalizationScriptReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSIPNormalizationScript(\StructType\AddSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCustomUserFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCustomUserField(\StructType\AddCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGatewaySccpEndpointsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addGatewaySccpEndpoints(\StructType\AddGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBillingServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addBillingServer(\StructType\AddBillingServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLbmGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLbmGroup(\StructType\AddLbmGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAnnouncementReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAnnouncement(\StructType\AddAnnouncementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddServiceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addServiceProfile(\StructType\AddServiceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLdapSyncCustomFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLdapSyncCustomField(\StructType\AddLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAudioCodecPreferenceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAudioCodecPreferenceList(\StructType\AddAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUcServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUcService(\StructType\AddUcServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLbmHubGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLbmHubGroup(\StructType\AddLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddImportedDirectoryUriCatalogsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addImportedDirectoryUriCatalogs(\StructType\AddImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddVohServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addVohServer(\StructType\AddVohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSdpTransparencyProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addSdpTransparencyProfile(\StructType\AddSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddFeatureGroupTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addFeatureGroupTemplate(\StructType\AddFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDirNumberAliasLookupandSyncReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addDirNumberAliasLookupandSync(\StructType\AddDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLocalRouteGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addLocalRouteGroup(\StructType\AddLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAdvertisedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addAdvertisedPatterns(\StructType\AddAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBlockedLearnedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addBlockedLearnedPatterns(\StructType\AddBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCCAProfilesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addCCAProfiles(\StructType\AddCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUniversalDeviceTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUniversalDeviceTemplate(\StructType\AddUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserProfileProvisionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUserProfileProvision(\StructType\AddUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addPresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddPresenceRedundancyGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addPresenceRedundancyGroup(\StructType\AddPresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addPresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddWifiHotspotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addWifiHotspot(\StructType\AddWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddWlanProfileGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addWlanProfileGroup(\StructType\AddWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddWLANProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addWLANProfile(\StructType\AddWLANProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUniversalLineTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addUniversalLineTemplate(\StructType\AddUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddNetworkAccessProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addNetworkAccessProfile(\StructType\AddNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addHttpProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddHttpProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addHttpProfile(\StructType\AddHttpProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addHttpProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addElinGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddElinGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addElinGroup(\StructType\AddElinGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addElinGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMobilityReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addMobility(\StructType\AddMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddApplicationToSoftkeyTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function addApplicationToSoftkeyTemplate(\StructType\AddApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSNMPCommunityStringReq $axlParams
     * @return \StructType\AddSNMPCommunityStringRes|bool
     */
    public function addSNMPCommunityString(\StructType\AddSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSNMPUserReq $axlParams
     * @return \StructType\AddSNMPUserRes|bool
     */
    public function addSNMPUser(\StructType\AddSNMPUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->addSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddSNMPCommunityStringRes|\StructType\AddSNMPUserRes|\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
