<?php

namespace EnumType;

/**
 * This class stands for XYellowAlarm EnumType
 * @subpackage Enumerations
 */
class XYellowAlarm
{
    /**
     * Constant for value 'Bit2'
     * @return string 'Bit2'
     */
    const VALUE_BIT_2 = 'Bit2';
    /**
     * Constant for value 'F-Bit'
     * @return string 'F-Bit'
     */
    const VALUE_F_BIT = 'F-Bit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BIT_2
     * @uses self::VALUE_F_BIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BIT_2,
            self::VALUE_F_BIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
