<?php

namespace EnumType;

/**
 * This class stands for XWLANProfileChanges EnumType
 * @subpackage Enumerations
 */
class XWLANProfileChanges
{
    /**
     * Constant for value 'Allowed'
     * @return string 'Allowed'
     */
    const VALUE_ALLOWED = 'Allowed';
    /**
     * Constant for value 'Disallowed'
     * @return string 'Disallowed'
     */
    const VALUE_DISALLOWED = 'Disallowed';
    /**
     * Constant for value 'Restricted'
     * @return string 'Restricted'
     */
    const VALUE_RESTRICTED = 'Restricted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLOWED
     * @uses self::VALUE_DISALLOWED
     * @uses self::VALUE_RESTRICTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLOWED,
            self::VALUE_DISALLOWED,
            self::VALUE_RESTRICTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
