<?php

namespace EnumType;

/**
 * This class stands for XVPNClientAuthentication EnumType
 * @subpackage Enumerations
 */
class XVPNClientAuthentication
{
    /**
     * Constant for value 'User and Password'
     * @return string 'User and Password'
     */
    const VALUE_USER_AND_PASSWORD = 'User and Password';
    /**
     * Constant for value 'Password Only'
     * @return string 'Password Only'
     */
    const VALUE_PASSWORD_ONLY = 'Password Only';
    /**
     * Constant for value 'Certificate'
     * @return string 'Certificate'
     */
    const VALUE_CERTIFICATE = 'Certificate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER_AND_PASSWORD
     * @uses self::VALUE_PASSWORD_ONLY
     * @uses self::VALUE_CERTIFICATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER_AND_PASSWORD,
            self::VALUE_PASSWORD_ONLY,
            self::VALUE_CERTIFICATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
