<?php

namespace EnumType;

/**
 * This class stands for XStartDialProtocol EnumType
 * @subpackage Enumerations
 */
class XStartDialProtocol
{
    /**
     * Constant for value 'Not Set'
     * @return string 'Not Set'
     */
    const VALUE_NOT_SET = 'Not Set';
    /**
     * Constant for value 'Immediate'
     * @return string 'Immediate'
     */
    const VALUE_IMMEDIATE = 'Immediate';
    /**
     * Constant for value 'Wink Start Feature Group B'
     * @return string 'Wink Start Feature Group B'
     */
    const VALUE_WINK_START_FEATURE_GROUP_B = 'Wink Start Feature Group B';
    /**
     * Constant for value 'Delay Dial'
     * @return string 'Delay Dial'
     */
    const VALUE_DELAY_DIAL = 'Delay Dial';
    /**
     * Constant for value 'Wink Start Feature Group D'
     * @return string 'Wink Start Feature Group D'
     */
    const VALUE_WINK_START_FEATURE_GROUP_D = 'Wink Start Feature Group D';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_IMMEDIATE
     * @uses self::VALUE_WINK_START_FEATURE_GROUP_B
     * @uses self::VALUE_DELAY_DIAL
     * @uses self::VALUE_WINK_START_FEATURE_GROUP_D
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_IMMEDIATE,
            self::VALUE_WINK_START_FEATURE_GROUP_B,
            self::VALUE_DELAY_DIAL,
            self::VALUE_WINK_START_FEATURE_GROUP_D,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
