<?php

namespace EnumType;

/**
 * This class stands for XHuntAlgorithm EnumType
 * @subpackage Enumerations
 */
class XHuntAlgorithm
{
    /**
     * Constant for value 'Try next member; then, try next group in Hunt List'
     * @return string 'Try next member; then, try next group in Hunt List'
     */
    const VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST = 'Try next member; then, try next group in Hunt List';
    /**
     * Constant for value 'Try next member, but do not go to next group'
     * @return string 'Try next member, but do not go to next group'
     */
    const VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP = 'Try next member, but do not go to next group';
    /**
     * Constant for value 'Skip remaining members, and go directly to next group'
     * @return string 'Skip remaining members, and go directly to next group'
     */
    const VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP = 'Skip remaining members, and go directly to next group';
    /**
     * Constant for value 'Stop hunting'
     * @return string 'Stop hunting'
     */
    const VALUE_STOP_HUNTING = 'Stop hunting';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST
     * @uses self::VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP
     * @uses self::VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP
     * @uses self::VALUE_STOP_HUNTING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRY_NEXT_MEMBER_THEN_TRY_NEXT_GROUP_IN_HUNT_LIST,
            self::VALUE_TRY_NEXT_MEMBER_BUT_DO_NOT_GO_TO_NEXT_GROUP,
            self::VALUE_SKIP_REMAINING_MEMBERS_AND_GO_DIRECTLY_TO_NEXT_GROUP,
            self::VALUE_STOP_HUNTING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
