<?php

namespace EnumType;

/**
 * This class stands for XEncode EnumType
 * @subpackage Enumerations
 */
class XEncode
{
    /**
     * Constant for value 'A-law'
     * @return string 'A-law'
     */
    const VALUE_A_LAW = 'A-law';
    /**
     * Constant for value 'u-law'
     * @return string 'u-law'
     */
    const VALUE_U_LAW = 'u-law';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A_LAW
     * @uses self::VALUE_U_LAW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A_LAW,
            self::VALUE_U_LAW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
