<?php

namespace EnumType;

/**
 * This class stands for XChangeAction EnumType
 * @subpackage Enumerations
 */
class XChangeAction
{
    /**
     * Constant for value 'a'
     * @return string 'a'
     */
    const VALUE_A = 'a';
    /**
     * Constant for value 'r'
     * @return string 'r'
     */
    const VALUE_R = 'r';
    /**
     * Constant for value 'u'
     * @return string 'u'
     */
    const VALUE_U = 'u';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_A
     * @uses self::VALUE_R
     * @uses self::VALUE_U
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A,
            self::VALUE_R,
            self::VALUE_U,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
