<?php

namespace EnumType;

/**
 * This class stands for XCertificateService EnumType
 * @subpackage Enumerations
 */
class XCertificateService
{
    /**
     * Constant for value 'Phone-trust'
     * @return string 'Phone-trust'
     */
    const VALUE_PHONE_TRUST = 'Phone-trust';
    /**
     * Constant for value 'Phone-VPN-trust'
     * @return string 'Phone-VPN-trust'
     */
    const VALUE_PHONE_VPN_TRUST = 'Phone-VPN-trust';
    /**
     * Constant for value 'CallManager'
     * @return string 'CallManager'
     */
    const VALUE_CALL_MANAGER = 'CallManager';
    /**
     * Constant for value 'CallManager-trust'
     * @return string 'CallManager-trust'
     */
    const VALUE_CALL_MANAGER_TRUST = 'CallManager-trust';
    /**
     * Constant for value 'tomcat'
     * @return string 'tomcat'
     */
    const VALUE_TOMCAT = 'tomcat';
    /**
     * Constant for value 'tomcat-trust'
     * @return string 'tomcat-trust'
     */
    const VALUE_TOMCAT_TRUST = 'tomcat-trust';
    /**
     * Constant for value 'ipsec'
     * @return string 'ipsec'
     */
    const VALUE_IPSEC = 'ipsec';
    /**
     * Constant for value 'ipsec-trust'
     * @return string 'ipsec-trust'
     */
    const VALUE_IPSEC_TRUST = 'ipsec-trust';
    /**
     * Constant for value 'CAPF'
     * @return string 'CAPF'
     */
    const VALUE_CAPF = 'CAPF';
    /**
     * Constant for value 'CAPF-trust'
     * @return string 'CAPF-trust'
     */
    const VALUE_CAPF_TRUST = 'CAPF-trust';
    /**
     * Constant for value 'TVS'
     * @return string 'TVS'
     */
    const VALUE_TVS = 'TVS';
    /**
     * Constant for value 'TVS-trust'
     * @return string 'TVS-trust'
     */
    const VALUE_TVS_TRUST = 'TVS-trust';
    /**
     * Constant for value 'directory-trust'
     * @return string 'directory-trust'
     */
    const VALUE_DIRECTORY_TRUST = 'directory-trust';
    /**
     * Constant for value 'Phone-SAST-trust'
     * @return string 'Phone-SAST-trust'
     */
    const VALUE_PHONE_SAST_TRUST = 'Phone-SAST-trust';
    /**
     * Constant for value 'Phone-CTL-trust'
     * @return string 'Phone-CTL-trust'
     */
    const VALUE_PHONE_CTL_TRUST = 'Phone-CTL-trust';
    /**
     * Constant for value 'userlicensing-trust'
     * @return string 'userlicensing-trust'
     */
    const VALUE_USERLICENSING_TRUST = 'userlicensing-trust';
    /**
     * Constant for value 'ITLRecovery'
     * @return string 'ITLRecovery'
     */
    const VALUE_ITLRECOVERY = 'ITLRecovery';
    /**
     * Constant for value 'CallManager-ECDSA'
     * @return string 'CallManager-ECDSA'
     */
    const VALUE_CALL_MANAGER_ECDSA = 'CallManager-ECDSA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PHONE_TRUST
     * @uses self::VALUE_PHONE_VPN_TRUST
     * @uses self::VALUE_CALL_MANAGER
     * @uses self::VALUE_CALL_MANAGER_TRUST
     * @uses self::VALUE_TOMCAT
     * @uses self::VALUE_TOMCAT_TRUST
     * @uses self::VALUE_IPSEC
     * @uses self::VALUE_IPSEC_TRUST
     * @uses self::VALUE_CAPF
     * @uses self::VALUE_CAPF_TRUST
     * @uses self::VALUE_TVS
     * @uses self::VALUE_TVS_TRUST
     * @uses self::VALUE_DIRECTORY_TRUST
     * @uses self::VALUE_PHONE_SAST_TRUST
     * @uses self::VALUE_PHONE_CTL_TRUST
     * @uses self::VALUE_USERLICENSING_TRUST
     * @uses self::VALUE_ITLRECOVERY
     * @uses self::VALUE_CALL_MANAGER_ECDSA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHONE_TRUST,
            self::VALUE_PHONE_VPN_TRUST,
            self::VALUE_CALL_MANAGER,
            self::VALUE_CALL_MANAGER_TRUST,
            self::VALUE_TOMCAT,
            self::VALUE_TOMCAT_TRUST,
            self::VALUE_IPSEC,
            self::VALUE_IPSEC_TRUST,
            self::VALUE_CAPF,
            self::VALUE_CAPF_TRUST,
            self::VALUE_TVS,
            self::VALUE_TVS_TRUST,
            self::VALUE_DIRECTORY_TRUST,
            self::VALUE_PHONE_SAST_TRUST,
            self::VALUE_PHONE_CTL_TRUST,
            self::VALUE_USERLICENSING_TRUST,
            self::VALUE_ITLRECOVERY,
            self::VALUE_CALL_MANAGER_ECDSA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
