<?php

namespace EnumType;

/**
 * This class stands for XAutoAnswer EnumType
 * @subpackage Enumerations
 */
class XAutoAnswer
{
    /**
     * Constant for value 'Auto Answer Off'
     * @return string 'Auto Answer Off'
     */
    const VALUE_AUTO_ANSWER_OFF = 'Auto Answer Off';
    /**
     * Constant for value 'Auto Answer with Headset'
     * @return string 'Auto Answer with Headset'
     */
    const VALUE_AUTO_ANSWER_WITH_HEADSET = 'Auto Answer with Headset';
    /**
     * Constant for value 'Auto Answer with Speakerphone'
     * @return string 'Auto Answer with Speakerphone'
     */
    const VALUE_AUTO_ANSWER_WITH_SPEAKERPHONE = 'Auto Answer with Speakerphone';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTO_ANSWER_OFF
     * @uses self::VALUE_AUTO_ANSWER_WITH_HEADSET
     * @uses self::VALUE_AUTO_ANSWER_WITH_SPEAKERPHONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTO_ANSWER_OFF,
            self::VALUE_AUTO_ANSWER_WITH_HEADSET,
            self::VALUE_AUTO_ANSWER_WITH_SPEAKERPHONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
