<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XWifiHotspot StructType
 * @subpackage Structs
 */
class XWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The ssidPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ssidPrefix;
    /**
     * The frequencyBand
     * Meta informations extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The authenticationMethod
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMethod;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The userModifiable
     * Meta informations extracted from the WSDL
     * - default: Allowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The hostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 64
     * @var string
     */
    public $hostName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 1812
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The sharedSecret
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sharedSecret;
    /**
     * The pskPassPhrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pskPassPhrase;
    /**
     * The wepKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $passwordDescription;
    /**
     * Constructor method for XWifiHotspot
     * @uses XWifiHotspot::setName()
     * @uses XWifiHotspot::setSsidPrefix()
     * @uses XWifiHotspot::setFrequencyBand()
     * @uses XWifiHotspot::setAuthenticationMethod()
     * @uses XWifiHotspot::setDescription()
     * @uses XWifiHotspot::setUserModifiable()
     * @uses XWifiHotspot::setHostName()
     * @uses XWifiHotspot::setPort()
     * @uses XWifiHotspot::setSharedSecret()
     * @uses XWifiHotspot::setPskPassPhrase()
     * @uses XWifiHotspot::setWepKey()
     * @uses XWifiHotspot::setPasswordDescription()
     * @param string $name
     * @param string $ssidPrefix
     * @param string $frequencyBand
     * @param string $authenticationMethod
     * @param string $description
     * @param string $userModifiable
     * @param string $hostName
     * @param string $port
     * @param string $sharedSecret
     * @param string $pskPassPhrase
     * @param string $wepKey
     * @param string $passwordDescription
     */
    public function __construct($name = null, $ssidPrefix = null, $frequencyBand = 'Auto', $authenticationMethod = 'None', $description = null, $userModifiable = 'Allowed', $hostName = null, $port = '1812', $sharedSecret = null, $pskPassPhrase = null, $wepKey = null, $passwordDescription = null)
    {
        $this
            ->setName($name)
            ->setSsidPrefix($ssidPrefix)
            ->setFrequencyBand($frequencyBand)
            ->setAuthenticationMethod($authenticationMethod)
            ->setDescription($description)
            ->setUserModifiable($userModifiable)
            ->setHostName($hostName)
            ->setPort($port)
            ->setSharedSecret($sharedSecret)
            ->setPskPassPhrase($pskPassPhrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XWifiHotspot
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \StructType\XWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses \EnumType\XWiFiFrequency::valueIsValid()
     * @uses \EnumType\XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return \StructType\XWifiHotspot
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequencyBand, implode(', ', \EnumType\XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses \EnumType\XHotspotAuthenticationMethod::valueIsValid()
     * @uses \EnumType\XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return \StructType\XWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMethod, implode(', ', \EnumType\XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XWifiHotspot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses \EnumType\XWLANProfileChanges::valueIsValid()
     * @uses \EnumType\XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return \StructType\XWifiHotspot
     */
    public function setUserModifiable($userModifiable = 'Allowed')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userModifiable, implode(', ', \EnumType\XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \StructType\XWifiHotspot
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostName) && strlen($hostName) > 64) || (is_array($hostName) && count($hostName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($hostName) ? strlen($hostName) : count($hostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XWifiHotspot
     */
    public function setPort($port = '1812')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get sharedSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedSecret()
    {
        return isset($this->sharedSecret) ? $this->sharedSecret : null;
    }
    /**
     * Set sharedSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedSecret
     * @return \StructType\XWifiHotspot
     */
    public function setSharedSecret($sharedSecret = null)
    {
        // validation for constraint: string
        if (!is_null($sharedSecret) && !is_string($sharedSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sharedSecret)), __LINE__);
        }
        if (is_null($sharedSecret) || (is_array($sharedSecret) && empty($sharedSecret))) {
            unset($this->sharedSecret);
        } else {
            $this->sharedSecret = $sharedSecret;
        }
        return $this;
    }
    /**
     * Get pskPassPhrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPskPassPhrase()
    {
        return isset($this->pskPassPhrase) ? $this->pskPassPhrase : null;
    }
    /**
     * Set pskPassPhrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pskPassPhrase
     * @return \StructType\XWifiHotspot
     */
    public function setPskPassPhrase($pskPassPhrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassPhrase) && !is_string($pskPassPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pskPassPhrase)), __LINE__);
        }
        if (is_null($pskPassPhrase) || (is_array($pskPassPhrase) && empty($pskPassPhrase))) {
            unset($this->pskPassPhrase);
        } else {
            $this->pskPassPhrase = $pskPassPhrase;
        }
        return $this;
    }
    /**
     * Get wepKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWepKey()
    {
        return isset($this->wepKey) ? $this->wepKey : null;
    }
    /**
     * Set wepKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wepKey
     * @return \StructType\XWifiHotspot
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wepKey)), __LINE__);
        }
        if (is_null($wepKey) || (is_array($wepKey) && empty($wepKey))) {
            unset($this->wepKey);
        } else {
            $this->wepKey = $wepKey;
        }
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \StructType\XWifiHotspot
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($passwordDescription) && strlen($passwordDescription) > 255) || (is_array($passwordDescription) && count($passwordDescription) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($passwordDescription) ? strlen($passwordDescription) : count($passwordDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XWifiHotspot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
