<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUniversalDeviceTemplate StructType
 * @subpackage Structs
 */
class XUniversalDeviceTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The devicePool
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePool;
    /**
     * The deviceSecurityProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $deviceSecurityProfile;
    /**
     * The sipProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sipProfile;
    /**
     * The phoneButtonTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The commonPhoneProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $commonPhoneProfile;
    /**
     * The phonePersonalization
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $phonePersonalization;
    /**
     * The mtpPreferredOriginatingCodec
     * Meta informations extracted from the WSDL
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mtpPreferredOriginatingCodec;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - default: No Rollover
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The servicesProvisioning
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $servicesProvisioning;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The mlppIndication
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mlppIndication;
    /**
     * The mlppPreemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mlppPreemption;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The blfPresenceGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $blfPresenceGroup;
    /**
     * The blfAudibleAlertSettingPhoneBusy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $blfAudibleAlertSettingPhoneBusy;
    /**
     * The blfAudibleAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $blfAudibleAlertSettingPhoneIdle;
    /**
     * The location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $location;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The builtInBridge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $builtInBridge;
    /**
     * The recordingOptions
     * Meta informations extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $recordingOptions;
    /**
     * The privacy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacy;
    /**
     * The audibleMsgWaitingicatorPolicy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $audibleMsgWaitingicatorPolicy;
    /**
     * The visualMsgWaitingIndicatorPolicy
     * Meta informations extracted from the WSDL
     * - default: Use System Policy
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $visualMsgWaitingIndicatorPolicy;
    /**
     * The MaxNumberOfCalls
     * Meta informations extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $MaxNumberOfCalls;
    /**
     * The ringSettingWhenPhoneIdle
     * Meta informations extracted from the WSDL
     * - default: Ring
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ringSettingWhenPhoneIdle;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $busyTrigger;
    /**
     * The deviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceDescription;
    /**
     * The sipDialRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sipDialRules;
    /**
     * The callingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpace;
    /**
     * The callingPartyTransformationCSSForInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSSForInboundCalls;
    /**
     * The callingPartyTransformationCSSForOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingPartyTransformationCSSForOutboundCalls;
    /**
     * The reroutingCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $reroutingCallingSearchSpace;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    /**
     * The useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    /**
     * The commonDeviceConfiguration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $commonDeviceConfiguration;
    /**
     * The softkeyTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $softkeyTemplate;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The mediaTerminationPointRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mediaTerminationPointRequired;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requiredDtmfReception
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requiredDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Speeddials
     */
    public $speeddials;
    /**
     * The protectedDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $protectedDevice;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - default: RSA Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ecKeySize;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The secureShellUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureShellUser;
    /**
     * The secureShellPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureShellPassword;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mlppDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mlppDomain;
    /**
     * The doNotDisturb
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $doNotDisturb;
    /**
     * The dndIncomingCallAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndIncomingCallAlert;
    /**
     * The aarGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarGroup;
    /**
     * The aarCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarCallingSearchSpace;
    /**
     * The userHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSource;
    /**
     * The networkHoldMohAudioSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSource;
    /**
     * The geoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocation;
    /**
     * The mediaResourceGroupList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mediaResourceGroupList;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The requireOffPremiseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $ownerUserId;
    /**
     * The mobilityUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mobilityUserId;
    /**
     * The allowControlOfDeviceFromCti
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowControlOfDeviceFromCti;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The loggedIntoHuntGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $loggedIntoHuntGroup;
    /**
     * The proxyServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyServer;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $servicesUrl;
    /**
     * The idle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $idle;
    /**
     * The idleTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idleTimer;
    /**
     * The secureDirUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureDirUrl;
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messages;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The authenticationServer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationServer;
    /**
     * The directory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $directory;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $information;
    /**
     * The secureMessagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureMessagesUrl;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The externalPhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalPhoneNumber;
    /**
     * The logMissedCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $logMissedCalls;
    /**
     * The lineLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lineLabel;
    /**
     * The displayCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $displayCallerId;
    /**
     * The ringSettingWhenPhoneInUse
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ringSettingWhenPhoneInUse;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $directoryNumber;
    /**
     * The recordingProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $recordingProfile;
    /**
     * The callPickupGroupAudioAlertSettingPhoneActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneActive;
    /**
     * The callPickupGroupAudioAlertSettingPhoneIdle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callPickupGroupAudioAlertSettingPhoneIdle;
    /**
     * The monitoringCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $monitoringCallingSearchSpace;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * Constructor method for XUniversalDeviceTemplate
     * @uses XUniversalDeviceTemplate::setName()
     * @uses XUniversalDeviceTemplate::setDevicePool()
     * @uses XUniversalDeviceTemplate::setDeviceSecurityProfile()
     * @uses XUniversalDeviceTemplate::setSipProfile()
     * @uses XUniversalDeviceTemplate::setPhoneButtonTemplate()
     * @uses XUniversalDeviceTemplate::setCommonPhoneProfile()
     * @uses XUniversalDeviceTemplate::setPhonePersonalization()
     * @uses XUniversalDeviceTemplate::setMtpPreferredOriginatingCodec()
     * @uses XUniversalDeviceTemplate::setOutboundCallRollover()
     * @uses XUniversalDeviceTemplate::setUseTrustedRelayPoint()
     * @uses XUniversalDeviceTemplate::setAuthenticationMode()
     * @uses XUniversalDeviceTemplate::setKeySize()
     * @uses XUniversalDeviceTemplate::setServicesProvisioning()
     * @uses XUniversalDeviceTemplate::setPacketCaptureMode()
     * @uses XUniversalDeviceTemplate::setMlppIndication()
     * @uses XUniversalDeviceTemplate::setMlppPreemption()
     * @uses XUniversalDeviceTemplate::setDndOption()
     * @uses XUniversalDeviceTemplate::setBlfPresenceGroup()
     * @uses XUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneBusy()
     * @uses XUniversalDeviceTemplate::setBlfAudibleAlertSettingPhoneIdle()
     * @uses XUniversalDeviceTemplate::setLocation()
     * @uses XUniversalDeviceTemplate::setDeviceMobilityMode()
     * @uses XUniversalDeviceTemplate::setJoinAcrossLines()
     * @uses XUniversalDeviceTemplate::setAlwaysUsePrimeLine()
     * @uses XUniversalDeviceTemplate::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XUniversalDeviceTemplate::setSingleButtonBarge()
     * @uses XUniversalDeviceTemplate::setBuiltInBridge()
     * @uses XUniversalDeviceTemplate::setRecordingOptions()
     * @uses XUniversalDeviceTemplate::setPrivacy()
     * @uses XUniversalDeviceTemplate::setAudibleMsgWaitingicatorPolicy()
     * @uses XUniversalDeviceTemplate::setVisualMsgWaitingIndicatorPolicy()
     * @uses XUniversalDeviceTemplate::setMaxNumberOfCalls()
     * @uses XUniversalDeviceTemplate::setRingSettingWhenPhoneIdle()
     * @uses XUniversalDeviceTemplate::setBusyTrigger()
     * @uses XUniversalDeviceTemplate::setDeviceDescription()
     * @uses XUniversalDeviceTemplate::setSipDialRules()
     * @uses XUniversalDeviceTemplate::setCallingSearchSpace()
     * @uses XUniversalDeviceTemplate::setCallingPartyTransformationCSSForInboundCalls()
     * @uses XUniversalDeviceTemplate::setCallingPartyTransformationCSSForOutboundCalls()
     * @uses XUniversalDeviceTemplate::setReroutingCallingSearchSpace()
     * @uses XUniversalDeviceTemplate::setSubscribeCallingSearchSpaceName()
     * @uses XUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
     * @uses XUniversalDeviceTemplate::setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
     * @uses XUniversalDeviceTemplate::setCommonDeviceConfiguration()
     * @uses XUniversalDeviceTemplate::setSoftkeyTemplate()
     * @uses XUniversalDeviceTemplate::setFeatureControlPolicy()
     * @uses XUniversalDeviceTemplate::setMediaTerminationPointRequired()
     * @uses XUniversalDeviceTemplate::setUnattendedPort()
     * @uses XUniversalDeviceTemplate::setRequiredDtmfReception()
     * @uses XUniversalDeviceTemplate::setRfc2833Disabled()
     * @uses XUniversalDeviceTemplate::setSpeeddials()
     * @uses XUniversalDeviceTemplate::setProtectedDevice()
     * @uses XUniversalDeviceTemplate::setAuthenticationString()
     * @uses XUniversalDeviceTemplate::setKeyOrder()
     * @uses XUniversalDeviceTemplate::setEcKeySize()
     * @uses XUniversalDeviceTemplate::setPacketCaptureDuration()
     * @uses XUniversalDeviceTemplate::setSecureShellUser()
     * @uses XUniversalDeviceTemplate::setSecureShellPassword()
     * @uses XUniversalDeviceTemplate::setUserLocale()
     * @uses XUniversalDeviceTemplate::setNetworkLocale()
     * @uses XUniversalDeviceTemplate::setMlppDomain()
     * @uses XUniversalDeviceTemplate::setDoNotDisturb()
     * @uses XUniversalDeviceTemplate::setDndIncomingCallAlert()
     * @uses XUniversalDeviceTemplate::setAarGroup()
     * @uses XUniversalDeviceTemplate::setAarCallingSearchSpace()
     * @uses XUniversalDeviceTemplate::setUserHoldMohAudioSource()
     * @uses XUniversalDeviceTemplate::setNetworkHoldMohAudioSource()
     * @uses XUniversalDeviceTemplate::setGeoLocation()
     * @uses XUniversalDeviceTemplate::setMediaResourceGroupList()
     * @uses XUniversalDeviceTemplate::setRemoteDevice()
     * @uses XUniversalDeviceTemplate::setHotlineDevice()
     * @uses XUniversalDeviceTemplate::setRetryVideoCallAsAudio()
     * @uses XUniversalDeviceTemplate::setRequireOffPremiseLocation()
     * @uses XUniversalDeviceTemplate::setOwnerUserId()
     * @uses XUniversalDeviceTemplate::setMobilityUserId()
     * @uses XUniversalDeviceTemplate::setAllowControlOfDeviceFromCti()
     * @uses XUniversalDeviceTemplate::setIgnorePresentationIndicators()
     * @uses XUniversalDeviceTemplate::setEnableExtensionMobility()
     * @uses XUniversalDeviceTemplate::setLoggedIntoHuntGroup()
     * @uses XUniversalDeviceTemplate::setProxyServer()
     * @uses XUniversalDeviceTemplate::setServicesUrl()
     * @uses XUniversalDeviceTemplate::setIdle()
     * @uses XUniversalDeviceTemplate::setIdleTimer()
     * @uses XUniversalDeviceTemplate::setSecureDirUrl()
     * @uses XUniversalDeviceTemplate::setMessages()
     * @uses XUniversalDeviceTemplate::setSecureIdleUrl()
     * @uses XUniversalDeviceTemplate::setAuthenticationServer()
     * @uses XUniversalDeviceTemplate::setDirectory()
     * @uses XUniversalDeviceTemplate::setSecureServicesUrl()
     * @uses XUniversalDeviceTemplate::setInformation()
     * @uses XUniversalDeviceTemplate::setSecureMessagesUrl()
     * @uses XUniversalDeviceTemplate::setSecureInformationUrl()
     * @uses XUniversalDeviceTemplate::setSecureAuthenticationUrl()
     * @uses XUniversalDeviceTemplate::setExternalPhoneNumber()
     * @uses XUniversalDeviceTemplate::setLogMissedCalls()
     * @uses XUniversalDeviceTemplate::setLineLabel()
     * @uses XUniversalDeviceTemplate::setDisplayCallerId()
     * @uses XUniversalDeviceTemplate::setRingSettingWhenPhoneInUse()
     * @uses XUniversalDeviceTemplate::setDirectoryNumber()
     * @uses XUniversalDeviceTemplate::setRecordingProfile()
     * @uses XUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneActive()
     * @uses XUniversalDeviceTemplate::setCallPickupGroupAudioAlertSettingPhoneIdle()
     * @uses XUniversalDeviceTemplate::setMonitoringCallingSearchSpace()
     * @uses XUniversalDeviceTemplate::setConfidentialAccess()
     * @uses XUniversalDeviceTemplate::setServices()
     * @param string $name
     * @param \StructType\XFkType $devicePool
     * @param \StructType\XFkType $deviceSecurityProfile
     * @param \StructType\XFkType $sipProfile
     * @param \StructType\XFkType $phoneButtonTemplate
     * @param \StructType\XFkType $commonPhoneProfile
     * @param string $phonePersonalization
     * @param string $mtpPreferredOriginatingCodec
     * @param string $outboundCallRollover
     * @param string $useTrustedRelayPoint
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $servicesProvisioning
     * @param string $packetCaptureMode
     * @param string $mlppIndication
     * @param string $mlppPreemption
     * @param string $dndOption
     * @param \StructType\XFkType $blfPresenceGroup
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @param \StructType\XFkType $location
     * @param string $deviceMobilityMode
     * @param string $joinAcrossLines
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $singleButtonBarge
     * @param string $builtInBridge
     * @param string $recordingOptions
     * @param string $privacy
     * @param string $audibleMsgWaitingicatorPolicy
     * @param string $visualMsgWaitingIndicatorPolicy
     * @param string $maxNumberOfCalls
     * @param string $ringSettingWhenPhoneIdle
     * @param string $busyTrigger
     * @param string $deviceDescription
     * @param \StructType\XFkType $sipDialRules
     * @param \StructType\XFkType $callingSearchSpace
     * @param \StructType\XFkType $callingPartyTransformationCSSForInboundCalls
     * @param \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls
     * @param \StructType\XFkType $reroutingCallingSearchSpace
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @param \StructType\XFkType $commonDeviceConfiguration
     * @param \StructType\XFkType $softkeyTemplate
     * @param \StructType\XFkType $featureControlPolicy
     * @param string $mediaTerminationPointRequired
     * @param string $unattendedPort
     * @param string $requiredDtmfReception
     * @param string $rfc2833Disabled
     * @param \StructType\Speeddials $speeddials
     * @param string $protectedDevice
     * @param string $authenticationString
     * @param string $keyOrder
     * @param string $ecKeySize
     * @param string $packetCaptureDuration
     * @param string $secureShellUser
     * @param string $secureShellPassword
     * @param string $userLocale
     * @param string $networkLocale
     * @param \StructType\XFkType $mlppDomain
     * @param string $doNotDisturb
     * @param string $dndIncomingCallAlert
     * @param \StructType\XFkType $aarGroup
     * @param \StructType\XFkType $aarCallingSearchSpace
     * @param string $userHoldMohAudioSource
     * @param string $networkHoldMohAudioSource
     * @param \StructType\XFkType $geoLocation
     * @param \StructType\XFkType $mediaResourceGroupList
     * @param string $remoteDevice
     * @param string $hotlineDevice
     * @param string $retryVideoCallAsAudio
     * @param string $requireOffPremiseLocation
     * @param \StructType\XFkType $ownerUserId
     * @param \StructType\XFkType $mobilityUserId
     * @param string $allowControlOfDeviceFromCti
     * @param string $ignorePresentationIndicators
     * @param string $enableExtensionMobility
     * @param string $loggedIntoHuntGroup
     * @param string $proxyServer
     * @param string $servicesUrl
     * @param string $idle
     * @param string $idleTimer
     * @param string $secureDirUrl
     * @param string $messages
     * @param string $secureIdleUrl
     * @param string $authenticationServer
     * @param string $directory
     * @param string $secureServicesUrl
     * @param string $information
     * @param string $secureMessagesUrl
     * @param string $secureInformationUrl
     * @param string $secureAuthenticationUrl
     * @param string $externalPhoneNumber
     * @param string $logMissedCalls
     * @param string $lineLabel
     * @param string $displayCallerId
     * @param string $ringSettingWhenPhoneInUse
     * @param \StructType\XFkType $directoryNumber
     * @param \StructType\XFkType $recordingProfile
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @param \StructType\XFkType $monitoringCallingSearchSpace
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\Services $services
     */
    public function __construct($name = null, \StructType\XFkType $devicePool = null, \StructType\XFkType $deviceSecurityProfile = null, \StructType\XFkType $sipProfile = null, \StructType\XFkType $phoneButtonTemplate = null, \StructType\XFkType $commonPhoneProfile = null, $phonePersonalization = 'Default', $mtpPreferredOriginatingCodec = '711ulaw', $outboundCallRollover = 'No Rollover', $useTrustedRelayPoint = 'Default', $authenticationMode = 'By Null String', $keySize = '1024', $servicesProvisioning = 'Default', $packetCaptureMode = 'None', $mlppIndication = 'Off', $mlppPreemption = 'Default', $dndOption = 'Ringer Off', \StructType\XFkType $blfPresenceGroup = null, $blfAudibleAlertSettingPhoneBusy = 'Default', $blfAudibleAlertSettingPhoneIdle = 'Default', \StructType\XFkType $location = null, $deviceMobilityMode = 'Default', $joinAcrossLines = 'Default', $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', $singleButtonBarge = 'Default', $builtInBridge = 'Default', $recordingOptions = 'Call Recording Disabled', $privacy = 'Default', $audibleMsgWaitingicatorPolicy = 'Default', $visualMsgWaitingIndicatorPolicy = 'Use System Policy', $maxNumberOfCalls = '2', $ringSettingWhenPhoneIdle = 'Ring', $busyTrigger = '1', $deviceDescription = null, \StructType\XFkType $sipDialRules = null, \StructType\XFkType $callingSearchSpace = null, \StructType\XFkType $callingPartyTransformationCSSForInboundCalls = null, \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls = null, \StructType\XFkType $reroutingCallingSearchSpace = null, \StructType\XFkType $subscribeCallingSearchSpaceName = null, $useDevicePoolCallingPartyTransformationCSSforInboundCalls = null, $useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null, \StructType\XFkType $commonDeviceConfiguration = null, \StructType\XFkType $softkeyTemplate = null, \StructType\XFkType $featureControlPolicy = null, $mediaTerminationPointRequired = null, $unattendedPort = null, $requiredDtmfReception = null, $rfc2833Disabled = null, \StructType\Speeddials $speeddials = null, $protectedDevice = null, $authenticationString = null, $keyOrder = 'RSA Only', $ecKeySize = '384', $packetCaptureDuration = '0', $secureShellUser = null, $secureShellPassword = null, $userLocale = null, $networkLocale = null, \StructType\XFkType $mlppDomain = null, $doNotDisturb = null, $dndIncomingCallAlert = null, \StructType\XFkType $aarGroup = null, \StructType\XFkType $aarCallingSearchSpace = null, $userHoldMohAudioSource = null, $networkHoldMohAudioSource = null, \StructType\XFkType $geoLocation = null, \StructType\XFkType $mediaResourceGroupList = null, $remoteDevice = null, $hotlineDevice = null, $retryVideoCallAsAudio = null, $requireOffPremiseLocation = null, \StructType\XFkType $ownerUserId = null, \StructType\XFkType $mobilityUserId = null, $allowControlOfDeviceFromCti = null, $ignorePresentationIndicators = null, $enableExtensionMobility = null, $loggedIntoHuntGroup = null, $proxyServer = null, $servicesUrl = null, $idle = null, $idleTimer = null, $secureDirUrl = null, $messages = null, $secureIdleUrl = null, $authenticationServer = null, $directory = null, $secureServicesUrl = null, $information = null, $secureMessagesUrl = null, $secureInformationUrl = null, $secureAuthenticationUrl = null, $externalPhoneNumber = null, $logMissedCalls = null, $lineLabel = null, $displayCallerId = null, $ringSettingWhenPhoneInUse = 'Use System Default', \StructType\XFkType $directoryNumber = null, \StructType\XFkType $recordingProfile = null, $callPickupGroupAudioAlertSettingPhoneActive = null, $callPickupGroupAudioAlertSettingPhoneIdle = null, \StructType\XFkType $monitoringCallingSearchSpace = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\Services $services = null)
    {
        $this
            ->setName($name)
            ->setDevicePool($devicePool)
            ->setDeviceSecurityProfile($deviceSecurityProfile)
            ->setSipProfile($sipProfile)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setCommonPhoneProfile($commonPhoneProfile)
            ->setPhonePersonalization($phonePersonalization)
            ->setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setServicesProvisioning($servicesProvisioning)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setMlppIndication($mlppIndication)
            ->setMlppPreemption($mlppPreemption)
            ->setDndOption($dndOption)
            ->setBlfPresenceGroup($blfPresenceGroup)
            ->setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy)
            ->setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle)
            ->setLocation($location)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setBuiltInBridge($builtInBridge)
            ->setRecordingOptions($recordingOptions)
            ->setPrivacy($privacy)
            ->setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy)
            ->setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy)
            ->setMaxNumberOfCalls($maxNumberOfCalls)
            ->setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle)
            ->setBusyTrigger($busyTrigger)
            ->setDeviceDescription($deviceDescription)
            ->setSipDialRules($sipDialRules)
            ->setCallingSearchSpace($callingSearchSpace)
            ->setCallingPartyTransformationCSSForInboundCalls($callingPartyTransformationCSSForInboundCalls)
            ->setCallingPartyTransformationCSSForOutboundCalls($callingPartyTransformationCSSForOutboundCalls)
            ->setReroutingCallingSearchSpace($reroutingCallingSearchSpace)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls)
            ->setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)
            ->setCommonDeviceConfiguration($commonDeviceConfiguration)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setMediaTerminationPointRequired($mediaTerminationPointRequired)
            ->setUnattendedPort($unattendedPort)
            ->setRequiredDtmfReception($requiredDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setSpeeddials($speeddials)
            ->setProtectedDevice($protectedDevice)
            ->setAuthenticationString($authenticationString)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSecureShellUser($secureShellUser)
            ->setSecureShellPassword($secureShellPassword)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setMlppDomain($mlppDomain)
            ->setDoNotDisturb($doNotDisturb)
            ->setDndIncomingCallAlert($dndIncomingCallAlert)
            ->setAarGroup($aarGroup)
            ->setAarCallingSearchSpace($aarCallingSearchSpace)
            ->setUserHoldMohAudioSource($userHoldMohAudioSource)
            ->setNetworkHoldMohAudioSource($networkHoldMohAudioSource)
            ->setGeoLocation($geoLocation)
            ->setMediaResourceGroupList($mediaResourceGroupList)
            ->setRemoteDevice($remoteDevice)
            ->setHotlineDevice($hotlineDevice)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setOwnerUserId($ownerUserId)
            ->setMobilityUserId($mobilityUserId)
            ->setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setLoggedIntoHuntGroup($loggedIntoHuntGroup)
            ->setProxyServer($proxyServer)
            ->setServicesUrl($servicesUrl)
            ->setIdle($idle)
            ->setIdleTimer($idleTimer)
            ->setSecureDirUrl($secureDirUrl)
            ->setMessages($messages)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAuthenticationServer($authenticationServer)
            ->setDirectory($directory)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setInformation($information)
            ->setSecureMessagesUrl($secureMessagesUrl)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setExternalPhoneNumber($externalPhoneNumber)
            ->setLogMissedCalls($logMissedCalls)
            ->setLineLabel($lineLabel)
            ->setDisplayCallerId($displayCallerId)
            ->setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse)
            ->setDirectoryNumber($directoryNumber)
            ->setRecordingProfile($recordingProfile)
            ->setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive)
            ->setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle)
            ->setMonitoringCallingSearchSpace($monitoringCallingSearchSpace)
            ->setConfidentialAccess($confidentialAccess)
            ->setServices($services);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get devicePool value
     * @return \StructType\XFkType
     */
    public function getDevicePool()
    {
        return $this->devicePool;
    }
    /**
     * Set devicePool value
     * @param \StructType\XFkType $devicePool
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDevicePool(\StructType\XFkType $devicePool = null)
    {
        $this->devicePool = $devicePool;
        return $this;
    }
    /**
     * Get deviceSecurityProfile value
     * @return \StructType\XFkType
     */
    public function getDeviceSecurityProfile()
    {
        return $this->deviceSecurityProfile;
    }
    /**
     * Set deviceSecurityProfile value
     * @param \StructType\XFkType $deviceSecurityProfile
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDeviceSecurityProfile(\StructType\XFkType $deviceSecurityProfile = null)
    {
        $this->deviceSecurityProfile = $deviceSecurityProfile;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return \StructType\XFkType
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param \StructType\XFkType $sipProfile
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSipProfile(\StructType\XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * @return \StructType\XFkType
     */
    public function getPhoneButtonTemplate()
    {
        return $this->phoneButtonTemplate;
    }
    /**
     * Set phoneButtonTemplate value
     * @param \StructType\XFkType $phoneButtonTemplate
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setPhoneButtonTemplate(\StructType\XFkType $phoneButtonTemplate = null)
    {
        $this->phoneButtonTemplate = $phoneButtonTemplate;
        return $this;
    }
    /**
     * Get commonPhoneProfile value
     * @return \StructType\XFkType
     */
    public function getCommonPhoneProfile()
    {
        return $this->commonPhoneProfile;
    }
    /**
     * Set commonPhoneProfile value
     * @param \StructType\XFkType $commonPhoneProfile
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCommonPhoneProfile(\StructType\XFkType $commonPhoneProfile = null)
    {
        $this->commonPhoneProfile = $commonPhoneProfile;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses \EnumType\XPhonePersonalization::valueIsValid()
     * @uses \EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setPhonePersonalization($phonePersonalization = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phonePersonalization, implode(', ', \EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get mtpPreferredOriginatingCodec value
     * @return string
     */
    public function getMtpPreferredOriginatingCodec()
    {
        return $this->mtpPreferredOriginatingCodec;
    }
    /**
     * Set mtpPreferredOriginatingCodec value
     * @uses \EnumType\XSIPCodec::valueIsValid()
     * @uses \EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferredOriginatingCodec
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMtpPreferredOriginatingCodec($mtpPreferredOriginatingCodec = '711ulaw')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPCodec::valueIsValid($mtpPreferredOriginatingCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferredOriginatingCodec, implode(', ', \EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferredOriginatingCodec = $mtpPreferredOriginatingCodec;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses \EnumType\XOutboundCallRollover::valueIsValid()
     * @uses \EnumType\XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setOutboundCallRollover($outboundCallRollover = 'No Rollover')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', \EnumType\XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get servicesProvisioning value
     * @return string
     */
    public function getServicesProvisioning()
    {
        return $this->servicesProvisioning;
    }
    /**
     * Set servicesProvisioning value
     * @uses \EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicesProvisioning
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setServicesProvisioning($servicesProvisioning = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceDisplay::valueIsValid($servicesProvisioning)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $servicesProvisioning, implode(', ', \EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->servicesProvisioning = $servicesProvisioning;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndication
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMlppIndication($mlppIndication = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndication, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppPreemption
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMlppPreemption($mlppPreemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($mlppPreemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppPreemption, implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \EnumType\XDNDOption::valueIsValid()
     * @uses \EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get blfPresenceGroup value
     * @return \StructType\XFkType
     */
    public function getBlfPresenceGroup()
    {
        return $this->blfPresenceGroup;
    }
    /**
     * Set blfPresenceGroup value
     * @param \StructType\XFkType $blfPresenceGroup
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setBlfPresenceGroup(\StructType\XFkType $blfPresenceGroup = null)
    {
        $this->blfPresenceGroup = $blfPresenceGroup;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneBusy value
     * @return string
     */
    public function getBlfAudibleAlertSettingPhoneBusy()
    {
        return $this->blfAudibleAlertSettingPhoneBusy;
    }
    /**
     * Set blfAudibleAlertSettingPhoneBusy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneBusy
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneBusy($blfAudibleAlertSettingPhoneBusy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($blfAudibleAlertSettingPhoneBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneBusy, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneBusy = $blfAudibleAlertSettingPhoneBusy;
        return $this;
    }
    /**
     * Get blfAudibleAlertSettingPhoneIdle value
     * @return string
     */
    public function getBlfAudibleAlertSettingPhoneIdle()
    {
        return $this->blfAudibleAlertSettingPhoneIdle;
    }
    /**
     * Set blfAudibleAlertSettingPhoneIdle value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blfAudibleAlertSettingPhoneIdle
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setBlfAudibleAlertSettingPhoneIdle($blfAudibleAlertSettingPhoneIdle = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($blfAudibleAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blfAudibleAlertSettingPhoneIdle, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->blfAudibleAlertSettingPhoneIdle = $blfAudibleAlertSettingPhoneIdle;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\XFkType
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\XFkType $location
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setLocation(\StructType\XFkType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDeviceMobilityMode($deviceMobilityMode = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \EnumType\XBarge::valueIsValid()
     * @uses \EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get builtInBridge value
     * @return string
     */
    public function getBuiltInBridge()
    {
        return $this->builtInBridge;
    }
    /**
     * Set builtInBridge value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridge
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setBuiltInBridge($builtInBridge = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($builtInBridge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridge, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridge = $builtInBridge;
        return $this;
    }
    /**
     * Get recordingOptions value
     * @return string
     */
    public function getRecordingOptions()
    {
        return $this->recordingOptions;
    }
    /**
     * Set recordingOptions value
     * @uses \EnumType\XRecordingFlag::valueIsValid()
     * @uses \EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingOptions
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRecordingOptions($recordingOptions = 'Call Recording Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRecordingFlag::valueIsValid($recordingOptions)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingOptions, implode(', ', \EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingOptions = $recordingOptions;
        return $this;
    }
    /**
     * Get privacy value
     * @return string
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacy
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setPrivacy($privacy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($privacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $privacy, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get audibleMsgWaitingicatorPolicy value
     * @return string
     */
    public function getAudibleMsgWaitingicatorPolicy()
    {
        return $this->audibleMsgWaitingicatorPolicy;
    }
    /**
     * Set audibleMsgWaitingicatorPolicy value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMsgWaitingicatorPolicy
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAudibleMsgWaitingicatorPolicy($audibleMsgWaitingicatorPolicy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($audibleMsgWaitingicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMsgWaitingicatorPolicy, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMsgWaitingicatorPolicy = $audibleMsgWaitingicatorPolicy;
        return $this;
    }
    /**
     * Get visualMsgWaitingIndicatorPolicy value
     * @return string
     */
    public function getVisualMsgWaitingIndicatorPolicy()
    {
        return $this->visualMsgWaitingIndicatorPolicy;
    }
    /**
     * Set visualMsgWaitingIndicatorPolicy value
     * @uses \EnumType\XMWLPolicy::valueIsValid()
     * @uses \EnumType\XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $visualMsgWaitingIndicatorPolicy
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setVisualMsgWaitingIndicatorPolicy($visualMsgWaitingIndicatorPolicy = 'Use System Policy')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMWLPolicy::valueIsValid($visualMsgWaitingIndicatorPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $visualMsgWaitingIndicatorPolicy, implode(', ', \EnumType\XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->visualMsgWaitingIndicatorPolicy = $visualMsgWaitingIndicatorPolicy;
        return $this;
    }
    /**
     * Get MaxNumberOfCalls value
     * @return string
     */
    public function getMaxNumberOfCalls()
    {
        return $this->MaxNumberOfCalls;
    }
    /**
     * Set MaxNumberOfCalls value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumberOfCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMaxNumberOfCalls($maxNumberOfCalls = '2')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxNumberOfCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumberOfCalls, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->MaxNumberOfCalls = $maxNumberOfCalls;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneIdle value
     * @return string
     */
    public function getRingSettingWhenPhoneIdle()
    {
        return $this->ringSettingWhenPhoneIdle;
    }
    /**
     * Set ringSettingWhenPhoneIdle value
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneIdle
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneIdle($ringSettingWhenPhoneIdle = 'Ring')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingWhenPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneIdle, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingWhenPhoneIdle = $ringSettingWhenPhoneIdle;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get deviceDescription value
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return $this->deviceDescription;
    }
    /**
     * Set deviceDescription value
     * @param string $deviceDescription
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceDescription)), __LINE__);
        }
        $this->deviceDescription = $deviceDescription;
        return $this;
    }
    /**
     * Get sipDialRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSipDialRules()
    {
        return isset($this->sipDialRules) ? $this->sipDialRules : null;
    }
    /**
     * Set sipDialRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $sipDialRules
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSipDialRules(\StructType\XFkType $sipDialRules = null)
    {
        if (is_null($sipDialRules) || (is_array($sipDialRules) && empty($sipDialRules))) {
            unset($this->sipDialRules);
        } else {
            $this->sipDialRules = $sipDialRules;
        }
        return $this;
    }
    /**
     * Get callingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpace()
    {
        return isset($this->callingSearchSpace) ? $this->callingSearchSpace : null;
    }
    /**
     * Set callingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingSearchSpace
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCallingSearchSpace(\StructType\XFkType $callingSearchSpace = null)
    {
        if (is_null($callingSearchSpace) || (is_array($callingSearchSpace) && empty($callingSearchSpace))) {
            unset($this->callingSearchSpace);
        } else {
            $this->callingSearchSpace = $callingSearchSpace;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForInboundCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSSForInboundCalls()
    {
        return isset($this->callingPartyTransformationCSSForInboundCalls) ? $this->callingPartyTransformationCSSForInboundCalls : null;
    }
    /**
     * Set callingPartyTransformationCSSForInboundCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyTransformationCSSForInboundCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForInboundCalls(\StructType\XFkType $callingPartyTransformationCSSForInboundCalls = null)
    {
        if (is_null($callingPartyTransformationCSSForInboundCalls) || (is_array($callingPartyTransformationCSSForInboundCalls) && empty($callingPartyTransformationCSSForInboundCalls))) {
            unset($this->callingPartyTransformationCSSForInboundCalls);
        } else {
            $this->callingPartyTransformationCSSForInboundCalls = $callingPartyTransformationCSSForInboundCalls;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationCSSForOutboundCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSSForOutboundCalls()
    {
        return isset($this->callingPartyTransformationCSSForOutboundCalls) ? $this->callingPartyTransformationCSSForOutboundCalls : null;
    }
    /**
     * Set callingPartyTransformationCSSForOutboundCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingPartyTransformationCSSForOutboundCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCallingPartyTransformationCSSForOutboundCalls(\StructType\XFkType $callingPartyTransformationCSSForOutboundCalls = null)
    {
        if (is_null($callingPartyTransformationCSSForOutboundCalls) || (is_array($callingPartyTransformationCSSForOutboundCalls) && empty($callingPartyTransformationCSSForOutboundCalls))) {
            unset($this->callingPartyTransformationCSSForOutboundCalls);
        } else {
            $this->callingPartyTransformationCSSForOutboundCalls = $callingPartyTransformationCSSForOutboundCalls;
        }
        return $this;
    }
    /**
     * Get reroutingCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getReroutingCallingSearchSpace()
    {
        return isset($this->reroutingCallingSearchSpace) ? $this->reroutingCallingSearchSpace : null;
    }
    /**
     * Set reroutingCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $reroutingCallingSearchSpace
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setReroutingCallingSearchSpace(\StructType\XFkType $reroutingCallingSearchSpace = null)
    {
        if (is_null($reroutingCallingSearchSpace) || (is_array($reroutingCallingSearchSpace) && empty($reroutingCallingSearchSpace))) {
            unset($this->reroutingCallingSearchSpace);
        } else {
            $this->reroutingCallingSearchSpace = $reroutingCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforInboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforInboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforInboundCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforInboundCalls($useDevicePoolCallingPartyTransformationCSSforInboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforInboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforInboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforInboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforInboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforInboundCalls = $useDevicePoolCallingPartyTransformationCSSforInboundCalls;
        return $this;
    }
    /**
     * Get useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @return string|null
     */
    public function getUseDevicePoolCallingPartyTransformationCSSforOutboundCalls()
    {
        return $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
    }
    /**
     * Set useDevicePoolCallingPartyTransformationCSSforOutboundCalls value
     * @param string $useDevicePoolCallingPartyTransformationCSSforOutboundCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUseDevicePoolCallingPartyTransformationCSSforOutboundCalls($useDevicePoolCallingPartyTransformationCSSforOutboundCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCallingPartyTransformationCSSforOutboundCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCallingPartyTransformationCSSforOutboundCalls) && !is_string($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCallingPartyTransformationCSSforOutboundCalls)), __LINE__);
        }
        $this->useDevicePoolCallingPartyTransformationCSSforOutboundCalls = $useDevicePoolCallingPartyTransformationCSSforOutboundCalls;
        return $this;
    }
    /**
     * Get commonDeviceConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfiguration()
    {
        return isset($this->commonDeviceConfiguration) ? $this->commonDeviceConfiguration : null;
    }
    /**
     * Set commonDeviceConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $commonDeviceConfiguration
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCommonDeviceConfiguration(\StructType\XFkType $commonDeviceConfiguration = null)
    {
        if (is_null($commonDeviceConfiguration) || (is_array($commonDeviceConfiguration) && empty($commonDeviceConfiguration))) {
            unset($this->commonDeviceConfiguration);
        } else {
            $this->commonDeviceConfiguration = $commonDeviceConfiguration;
        }
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSoftkeyTemplate()
    {
        return isset($this->softkeyTemplate) ? $this->softkeyTemplate : null;
    }
    /**
     * Set softkeyTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $softkeyTemplate
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSoftkeyTemplate(\StructType\XFkType $softkeyTemplate = null)
    {
        if (is_null($softkeyTemplate) || (is_array($softkeyTemplate) && empty($softkeyTemplate))) {
            unset($this->softkeyTemplate);
        } else {
            $this->softkeyTemplate = $softkeyTemplate;
        }
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $featureControlPolicy
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setFeatureControlPolicy(\StructType\XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get mediaTerminationPointRequired value
     * @return string|null
     */
    public function getMediaTerminationPointRequired()
    {
        return $this->mediaTerminationPointRequired;
    }
    /**
     * Set mediaTerminationPointRequired value
     * @param string $mediaTerminationPointRequired
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMediaTerminationPointRequired($mediaTerminationPointRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mediaTerminationPointRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mediaTerminationPointRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mediaTerminationPointRequired) && !is_string($mediaTerminationPointRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaTerminationPointRequired)), __LINE__);
        }
        $this->mediaTerminationPointRequired = $mediaTerminationPointRequired;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requiredDtmfReception value
     * @return string|null
     */
    public function getRequiredDtmfReception()
    {
        return $this->requiredDtmfReception;
    }
    /**
     * Set requiredDtmfReception value
     * @param string $requiredDtmfReception
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRequiredDtmfReception($requiredDtmfReception = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requiredDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requiredDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requiredDtmfReception) && !is_string($requiredDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requiredDtmfReception)), __LINE__);
        }
        $this->requiredDtmfReception = $requiredDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRfc2833Disabled($rfc2833Disabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \StructType\Speeddials $speeddials
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSpeeddials(\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get protectedDevice value
     * @return string|null
     */
    public function getProtectedDevice()
    {
        return $this->protectedDevice;
    }
    /**
     * Set protectedDevice value
     * @param string $protectedDevice
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setProtectedDevice($protectedDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($protectedDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($protectedDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protectedDevice) && !is_string($protectedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protectedDevice)), __LINE__);
        }
        $this->protectedDevice = $protectedDevice;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return string|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @uses \EnumType\XKeyOrder::valueIsValid()
     * @uses \EnumType\XKeyOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keyOrder
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setKeyOrder($keyOrder = 'RSA Only')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeyOrder::valueIsValid($keyOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keyOrder, implode(', ', \EnumType\XKeyOrder::getValidValues())), __LINE__);
        }
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return string|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @uses \EnumType\XECKeySize::valueIsValid()
     * @uses \EnumType\XECKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecKeySize
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setEcKeySize($ecKeySize = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XECKeySize::valueIsValid($ecKeySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecKeySize, implode(', ', \EnumType\XECKeySize::getValidValues())), __LINE__);
        }
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get secureShellUser value
     * @return string|null
     */
    public function getSecureShellUser()
    {
        return $this->secureShellUser;
    }
    /**
     * Set secureShellUser value
     * @param string $secureShellUser
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureShellUser($secureShellUser = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellUser) && !is_string($secureShellUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellUser)), __LINE__);
        }
        $this->secureShellUser = $secureShellUser;
        return $this;
    }
    /**
     * Get secureShellPassword value
     * @return string|null
     */
    public function getSecureShellPassword()
    {
        return $this->secureShellPassword;
    }
    /**
     * Set secureShellPassword value
     * @param string $secureShellPassword
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureShellPassword($secureShellPassword = null)
    {
        // validation for constraint: string
        if (!is_null($secureShellPassword) && !is_string($secureShellPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureShellPassword)), __LINE__);
        }
        $this->secureShellPassword = $secureShellPassword;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mlppDomain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMlppDomain()
    {
        return isset($this->mlppDomain) ? $this->mlppDomain : null;
    }
    /**
     * Set mlppDomain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mlppDomain
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMlppDomain(\StructType\XFkType $mlppDomain = null)
    {
        if (is_null($mlppDomain) || (is_array($mlppDomain) && empty($mlppDomain))) {
            unset($this->mlppDomain);
        } else {
            $this->mlppDomain = $mlppDomain;
        }
        return $this;
    }
    /**
     * Get doNotDisturb value
     * @return string|null
     */
    public function getDoNotDisturb()
    {
        return $this->doNotDisturb;
    }
    /**
     * Set doNotDisturb value
     * @param string $doNotDisturb
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDoNotDisturb($doNotDisturb = null)
    {
        // validation for constraint: pattern
        if (is_scalar($doNotDisturb) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($doNotDisturb, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doNotDisturb) && !is_string($doNotDisturb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doNotDisturb)), __LINE__);
        }
        $this->doNotDisturb = $doNotDisturb;
        return $this;
    }
    /**
     * Get dndIncomingCallAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndIncomingCallAlert()
    {
        return isset($this->dndIncomingCallAlert) ? $this->dndIncomingCallAlert : null;
    }
    /**
     * Set dndIncomingCallAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndIncomingCallAlert
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDndIncomingCallAlert($dndIncomingCallAlert = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($dndIncomingCallAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndIncomingCallAlert, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($dndIncomingCallAlert) || (is_array($dndIncomingCallAlert) && empty($dndIncomingCallAlert))) {
            unset($this->dndIncomingCallAlert);
        } else {
            $this->dndIncomingCallAlert = $dndIncomingCallAlert;
        }
        return $this;
    }
    /**
     * Get aarGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAarGroup()
    {
        return isset($this->aarGroup) ? $this->aarGroup : null;
    }
    /**
     * Set aarGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $aarGroup
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAarGroup(\StructType\XFkType $aarGroup = null)
    {
        if (is_null($aarGroup) || (is_array($aarGroup) && empty($aarGroup))) {
            unset($this->aarGroup);
        } else {
            $this->aarGroup = $aarGroup;
        }
        return $this;
    }
    /**
     * Get aarCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAarCallingSearchSpace()
    {
        return isset($this->aarCallingSearchSpace) ? $this->aarCallingSearchSpace : null;
    }
    /**
     * Set aarCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $aarCallingSearchSpace
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAarCallingSearchSpace(\StructType\XFkType $aarCallingSearchSpace = null)
    {
        if (is_null($aarCallingSearchSpace) || (is_array($aarCallingSearchSpace) && empty($aarCallingSearchSpace))) {
            unset($this->aarCallingSearchSpace);
        } else {
            $this->aarCallingSearchSpace = $aarCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSource()
    {
        return isset($this->userHoldMohAudioSource) ? $this->userHoldMohAudioSource : null;
    }
    /**
     * Set userHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSource
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setUserHoldMohAudioSource($userHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($userHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSource, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSource) || (is_array($userHoldMohAudioSource) && empty($userHoldMohAudioSource))) {
            unset($this->userHoldMohAudioSource);
        } else {
            $this->userHoldMohAudioSource = $userHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSource()
    {
        return isset($this->networkHoldMohAudioSource) ? $this->networkHoldMohAudioSource : null;
    }
    /**
     * Set networkHoldMohAudioSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSource
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setNetworkHoldMohAudioSource($networkHoldMohAudioSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($networkHoldMohAudioSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSource, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSource) || (is_array($networkHoldMohAudioSource) && empty($networkHoldMohAudioSource))) {
            unset($this->networkHoldMohAudioSource);
        } else {
            $this->networkHoldMohAudioSource = $networkHoldMohAudioSource;
        }
        return $this;
    }
    /**
     * Get geoLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocation()
    {
        return isset($this->geoLocation) ? $this->geoLocation : null;
    }
    /**
     * Set geoLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocation
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setGeoLocation(\StructType\XFkType $geoLocation = null)
    {
        if (is_null($geoLocation) || (is_array($geoLocation) && empty($geoLocation))) {
            unset($this->geoLocation);
        } else {
            $this->geoLocation = $geoLocation;
        }
        return $this;
    }
    /**
     * Get mediaResourceGroupList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceGroupList()
    {
        return isset($this->mediaResourceGroupList) ? $this->mediaResourceGroupList : null;
    }
    /**
     * Set mediaResourceGroupList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mediaResourceGroupList
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMediaResourceGroupList(\StructType\XFkType $mediaResourceGroupList = null)
    {
        if (is_null($mediaResourceGroupList) || (is_array($mediaResourceGroupList) && empty($mediaResourceGroupList))) {
            unset($this->mediaResourceGroupList);
        } else {
            $this->mediaResourceGroupList = $mediaResourceGroupList;
        }
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requireOffPremiseLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireOffPremiseLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireOffPremiseLocation) && !is_string($requireOffPremiseLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireOffPremiseLocation)), __LINE__);
        }
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get ownerUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getOwnerUserId()
    {
        return isset($this->ownerUserId) ? $this->ownerUserId : null;
    }
    /**
     * Set ownerUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $ownerUserId
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setOwnerUserId(\StructType\XFkType $ownerUserId = null)
    {
        if (is_null($ownerUserId) || (is_array($ownerUserId) && empty($ownerUserId))) {
            unset($this->ownerUserId);
        } else {
            $this->ownerUserId = $ownerUserId;
        }
        return $this;
    }
    /**
     * Get mobilityUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMobilityUserId()
    {
        return isset($this->mobilityUserId) ? $this->mobilityUserId : null;
    }
    /**
     * Set mobilityUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mobilityUserId
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMobilityUserId(\StructType\XFkType $mobilityUserId = null)
    {
        if (is_null($mobilityUserId) || (is_array($mobilityUserId) && empty($mobilityUserId))) {
            unset($this->mobilityUserId);
        } else {
            $this->mobilityUserId = $mobilityUserId;
        }
        return $this;
    }
    /**
     * Get allowControlOfDeviceFromCti value
     * @return string|null
     */
    public function getAllowControlOfDeviceFromCti()
    {
        return $this->allowControlOfDeviceFromCti;
    }
    /**
     * Set allowControlOfDeviceFromCti value
     * @param string $allowControlOfDeviceFromCti
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAllowControlOfDeviceFromCti($allowControlOfDeviceFromCti = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowControlOfDeviceFromCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowControlOfDeviceFromCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowControlOfDeviceFromCti) && !is_string($allowControlOfDeviceFromCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowControlOfDeviceFromCti)), __LINE__);
        }
        $this->allowControlOfDeviceFromCti = $allowControlOfDeviceFromCti;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get loggedIntoHuntGroup value
     * @return string|null
     */
    public function getLoggedIntoHuntGroup()
    {
        return $this->loggedIntoHuntGroup;
    }
    /**
     * Set loggedIntoHuntGroup value
     * @param string $loggedIntoHuntGroup
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setLoggedIntoHuntGroup($loggedIntoHuntGroup = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loggedIntoHuntGroup) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($loggedIntoHuntGroup, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loggedIntoHuntGroup) && !is_string($loggedIntoHuntGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loggedIntoHuntGroup)), __LINE__);
        }
        $this->loggedIntoHuntGroup = $loggedIntoHuntGroup;
        return $this;
    }
    /**
     * Get proxyServer value
     * @return string|null
     */
    public function getProxyServer()
    {
        return $this->proxyServer;
    }
    /**
     * Set proxyServer value
     * @param string $proxyServer
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setProxyServer($proxyServer = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServer) && !is_string($proxyServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServer)), __LINE__);
        }
        $this->proxyServer = $proxyServer;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get idle value
     * @return string|null
     */
    public function getIdle()
    {
        return $this->idle;
    }
    /**
     * Set idle value
     * @param string $idle
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setIdle($idle = null)
    {
        // validation for constraint: string
        if (!is_null($idle) && !is_string($idle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idle)), __LINE__);
        }
        $this->idle = $idle;
        return $this;
    }
    /**
     * Get idleTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdleTimer()
    {
        return isset($this->idleTimer) ? $this->idleTimer : null;
    }
    /**
     * Set idleTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimer
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setIdleTimer($idleTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($idleTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($idleTimer) || (is_array($idleTimer) && empty($idleTimer))) {
            unset($this->idleTimer);
        } else {
            $this->idleTimer = $idleTimer;
        }
        return $this;
    }
    /**
     * Get secureDirUrl value
     * @return string|null
     */
    public function getSecureDirUrl()
    {
        return $this->secureDirUrl;
    }
    /**
     * Set secureDirUrl value
     * @param string $secureDirUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureDirUrl($secureDirUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureDirUrl) && !is_string($secureDirUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirUrl)), __LINE__);
        }
        $this->secureDirUrl = $secureDirUrl;
        return $this;
    }
    /**
     * Get messages value
     * @return string|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @param string $messages
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMessages($messages = null)
    {
        // validation for constraint: string
        if (!is_null($messages) && !is_string($messages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messages)), __LINE__);
        }
        $this->messages = $messages;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get authenticationServer value
     * @return string|null
     */
    public function getAuthenticationServer()
    {
        return $this->authenticationServer;
    }
    /**
     * Set authenticationServer value
     * @param string $authenticationServer
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setAuthenticationServer($authenticationServer = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationServer) && !is_string($authenticationServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationServer)), __LINE__);
        }
        $this->authenticationServer = $authenticationServer;
        return $this;
    }
    /**
     * Get directory value
     * @return string|null
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDirectory($directory = null)
    {
        // validation for constraint: string
        if (!is_null($directory) && !is_string($directory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directory)), __LINE__);
        }
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get secureMessagesUrl value
     * @return string|null
     */
    public function getSecureMessagesUrl()
    {
        return $this->secureMessagesUrl;
    }
    /**
     * Set secureMessagesUrl value
     * @param string $secureMessagesUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureMessagesUrl($secureMessagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureMessagesUrl) && !is_string($secureMessagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessagesUrl)), __LINE__);
        }
        $this->secureMessagesUrl = $secureMessagesUrl;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get externalPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPhoneNumber()
    {
        return isset($this->externalPhoneNumber) ? $this->externalPhoneNumber : null;
    }
    /**
     * Set externalPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPhoneNumber
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setExternalPhoneNumber($externalPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalPhoneNumber) && !is_string($externalPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalPhoneNumber)), __LINE__);
        }
        if (is_null($externalPhoneNumber) || (is_array($externalPhoneNumber) && empty($externalPhoneNumber))) {
            unset($this->externalPhoneNumber);
        } else {
            $this->externalPhoneNumber = $externalPhoneNumber;
        }
        return $this;
    }
    /**
     * Get logMissedCalls value
     * @return string|null
     */
    public function getLogMissedCalls()
    {
        return $this->logMissedCalls;
    }
    /**
     * Set logMissedCalls value
     * @param string $logMissedCalls
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setLogMissedCalls($logMissedCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($logMissedCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($logMissedCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($logMissedCalls) && !is_string($logMissedCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logMissedCalls)), __LINE__);
        }
        $this->logMissedCalls = $logMissedCalls;
        return $this;
    }
    /**
     * Get lineLabel value
     * @return string|null
     */
    public function getLineLabel()
    {
        return $this->lineLabel;
    }
    /**
     * Set lineLabel value
     * @param string $lineLabel
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setLineLabel($lineLabel = null)
    {
        // validation for constraint: string
        if (!is_null($lineLabel) && !is_string($lineLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineLabel)), __LINE__);
        }
        $this->lineLabel = $lineLabel;
        return $this;
    }
    /**
     * Get displayCallerId value
     * @return string|null
     */
    public function getDisplayCallerId()
    {
        return $this->displayCallerId;
    }
    /**
     * Set displayCallerId value
     * @param string $displayCallerId
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDisplayCallerId($displayCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($displayCallerId) && !is_string($displayCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayCallerId)), __LINE__);
        }
        $this->displayCallerId = $displayCallerId;
        return $this;
    }
    /**
     * Get ringSettingWhenPhoneInUse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRingSettingWhenPhoneInUse()
    {
        return isset($this->ringSettingWhenPhoneInUse) ? $this->ringSettingWhenPhoneInUse : null;
    }
    /**
     * Set ringSettingWhenPhoneInUse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingWhenPhoneInUse
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRingSettingWhenPhoneInUse($ringSettingWhenPhoneInUse = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($ringSettingWhenPhoneInUse)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingWhenPhoneInUse, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($ringSettingWhenPhoneInUse) || (is_array($ringSettingWhenPhoneInUse) && empty($ringSettingWhenPhoneInUse))) {
            unset($this->ringSettingWhenPhoneInUse);
        } else {
            $this->ringSettingWhenPhoneInUse = $ringSettingWhenPhoneInUse;
        }
        return $this;
    }
    /**
     * Get directoryNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDirectoryNumber()
    {
        return isset($this->directoryNumber) ? $this->directoryNumber : null;
    }
    /**
     * Set directoryNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $directoryNumber
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setDirectoryNumber(\StructType\XFkType $directoryNumber = null)
    {
        if (is_null($directoryNumber) || (is_array($directoryNumber) && empty($directoryNumber))) {
            unset($this->directoryNumber);
        } else {
            $this->directoryNumber = $directoryNumber;
        }
        return $this;
    }
    /**
     * Get recordingProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRecordingProfile()
    {
        return isset($this->recordingProfile) ? $this->recordingProfile : null;
    }
    /**
     * Set recordingProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $recordingProfile
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setRecordingProfile(\StructType\XFkType $recordingProfile = null)
    {
        if (is_null($recordingProfile) || (is_array($recordingProfile) && empty($recordingProfile))) {
            unset($this->recordingProfile);
        } else {
            $this->recordingProfile = $recordingProfile;
        }
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneActive()
    {
        return isset($this->callPickupGroupAudioAlertSettingPhoneActive) ? $this->callPickupGroupAudioAlertSettingPhoneActive : null;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneActive
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneActive($callPickupGroupAudioAlertSettingPhoneActive = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneActive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneActive, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($callPickupGroupAudioAlertSettingPhoneActive) || (is_array($callPickupGroupAudioAlertSettingPhoneActive) && empty($callPickupGroupAudioAlertSettingPhoneActive))) {
            unset($this->callPickupGroupAudioAlertSettingPhoneActive);
        } else {
            $this->callPickupGroupAudioAlertSettingPhoneActive = $callPickupGroupAudioAlertSettingPhoneActive;
        }
        return $this;
    }
    /**
     * Get callPickupGroupAudioAlertSettingPhoneIdle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallPickupGroupAudioAlertSettingPhoneIdle()
    {
        return isset($this->callPickupGroupAudioAlertSettingPhoneIdle) ? $this->callPickupGroupAudioAlertSettingPhoneIdle : null;
    }
    /**
     * Set callPickupGroupAudioAlertSettingPhoneIdle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XRingSetting::valueIsValid()
     * @uses \EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callPickupGroupAudioAlertSettingPhoneIdle
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setCallPickupGroupAudioAlertSettingPhoneIdle($callPickupGroupAudioAlertSettingPhoneIdle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRingSetting::valueIsValid($callPickupGroupAudioAlertSettingPhoneIdle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callPickupGroupAudioAlertSettingPhoneIdle, implode(', ', \EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($callPickupGroupAudioAlertSettingPhoneIdle) || (is_array($callPickupGroupAudioAlertSettingPhoneIdle) && empty($callPickupGroupAudioAlertSettingPhoneIdle))) {
            unset($this->callPickupGroupAudioAlertSettingPhoneIdle);
        } else {
            $this->callPickupGroupAudioAlertSettingPhoneIdle = $callPickupGroupAudioAlertSettingPhoneIdle;
        }
        return $this;
    }
    /**
     * Get monitoringCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMonitoringCallingSearchSpace()
    {
        return isset($this->monitoringCallingSearchSpace) ? $this->monitoringCallingSearchSpace : null;
    }
    /**
     * Set monitoringCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $monitoringCallingSearchSpace
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setMonitoringCallingSearchSpace(\StructType\XFkType $monitoringCallingSearchSpace = null)
    {
        if (is_null($monitoringCallingSearchSpace) || (is_array($monitoringCallingSearchSpace) && empty($monitoringCallingSearchSpace))) {
            unset($this->monitoringCallingSearchSpace);
        } else {
            $this->monitoringCallingSearchSpace = $monitoringCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\XUniversalDeviceTemplate
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XUniversalDeviceTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
