<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimePeriod StructType
 * @subpackage Structs
 */
class XTimePeriod extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The startTime
     * Meta informations extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta informations extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta informations extracted from the WSDL
     * - documentation: TimePeriod cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Period can be published.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The todOwnerIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The dayOfMonthEnd
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * Constructor method for XTimePeriod
     * @uses XTimePeriod::setName()
     * @uses XTimePeriod::setStartTime()
     * @uses XTimePeriod::setEndTime()
     * @uses XTimePeriod::setStartDay()
     * @uses XTimePeriod::setEndDay()
     * @uses XTimePeriod::setMonthOfYear()
     * @uses XTimePeriod::setDayOfMonth()
     * @uses XTimePeriod::setDescription()
     * @uses XTimePeriod::setIsPublished()
     * @uses XTimePeriod::setTodOwnerIdName()
     * @uses XTimePeriod::setDayOfMonthEnd()
     * @uses XTimePeriod::setMonthOfYearEnd()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $isPublished
     * @param \StructType\XFkType $todOwnerIdName
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     */
    public function __construct($name = null, $startTime = 'No Office Hours', $endTime = 'No Office Hours', $startDay = 'None', $endDay = 'None', $monthOfYear = 'None', $dayOfMonth = '0', $description = null, $isPublished = null, \StructType\XFkType $todOwnerIdName = null, $dayOfMonthEnd = '0', $monthOfYearEnd = 'None')
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XTimePeriod
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \StructType\XTimePeriod
     */
    public function setStartTime($startTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startTime, implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \StructType\XTimePeriod
     */
    public function setEndTime($endTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endTime, implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \StructType\XTimePeriod
     */
    public function setStartDay($startDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startDay, implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \StructType\XTimePeriod
     */
    public function setEndDay($endDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endDay, implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \StructType\XTimePeriod
     */
    public function setMonthOfYear($monthOfYear = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYear, implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \StructType\XTimePeriod
     */
    public function setDayOfMonth($dayOfMonth = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XTimePeriod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \StructType\XTimePeriod
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPublished, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPublished)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $todOwnerIdName
     * @return \StructType\XTimePeriod
     */
    public function setTodOwnerIdName(\StructType\XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \StructType\XTimePeriod
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonthEnd, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \StructType\XTimePeriod
     */
    public function setMonthOfYearEnd($monthOfYearEnd = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYearEnd, implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XTimePeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
