<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSubscribedService StructType
 * @subpackage Structs
 */
class XSubscribedService extends AbstractStructBase
{
    /**
     * The telecasterServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $telecasterServiceName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $url;
    /**
     * The urlButtonIndex
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlButtonIndex;
    /**
     * The urlLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $urlLabel;
    /**
     * The serviceNameAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $serviceNameAscii;
    /**
     * Constructor method for XSubscribedService
     * @uses XSubscribedService::setTelecasterServiceName()
     * @uses XSubscribedService::setName()
     * @uses XSubscribedService::setUrl()
     * @uses XSubscribedService::setUrlButtonIndex()
     * @uses XSubscribedService::setUrlLabel()
     * @uses XSubscribedService::setServiceNameAscii()
     * @param \StructType\XFkType $telecasterServiceName
     * @param string $name
     * @param string $url
     * @param string $urlButtonIndex
     * @param string $urlLabel
     * @param string $serviceNameAscii
     */
    public function __construct(\StructType\XFkType $telecasterServiceName = null, $name = null, $url = null, $urlButtonIndex = '0', $urlLabel = null, $serviceNameAscii = null)
    {
        $this
            ->setTelecasterServiceName($telecasterServiceName)
            ->setName($name)
            ->setUrl($url)
            ->setUrlButtonIndex($urlButtonIndex)
            ->setUrlLabel($urlLabel)
            ->setServiceNameAscii($serviceNameAscii);
    }
    /**
     * Get telecasterServiceName value
     * @return \StructType\XFkType
     */
    public function getTelecasterServiceName()
    {
        return $this->telecasterServiceName;
    }
    /**
     * Set telecasterServiceName value
     * @param \StructType\XFkType $telecasterServiceName
     * @return \StructType\XSubscribedService
     */
    public function setTelecasterServiceName(\StructType\XFkType $telecasterServiceName = null)
    {
        $this->telecasterServiceName = $telecasterServiceName;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSubscribedService
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 100) || (is_array($name) && count($name) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->url) ? $this->url : null;
    }
    /**
     * Set url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\XSubscribedService
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->url);
        } else {
            $this->url = $url;
        }
        return $this;
    }
    /**
     * Get urlButtonIndex value
     * @return string|null
     */
    public function getUrlButtonIndex()
    {
        return $this->urlButtonIndex;
    }
    /**
     * Set urlButtonIndex value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlButtonIndex
     * @return \StructType\XSubscribedService
     */
    public function setUrlButtonIndex($urlButtonIndex = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($urlButtonIndex)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urlButtonIndex, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->urlButtonIndex = $urlButtonIndex;
        return $this;
    }
    /**
     * Get urlLabel value
     * @return string|null
     */
    public function getUrlLabel()
    {
        return $this->urlLabel;
    }
    /**
     * Set urlLabel value
     * @param string $urlLabel
     * @return \StructType\XSubscribedService
     */
    public function setUrlLabel($urlLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($urlLabel) && strlen($urlLabel) > 50) || (is_array($urlLabel) && count($urlLabel) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($urlLabel) ? strlen($urlLabel) : count($urlLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($urlLabel) && !is_string($urlLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlLabel)), __LINE__);
        }
        $this->urlLabel = $urlLabel;
        return $this;
    }
    /**
     * Get serviceNameAscii value
     * @return string|null
     */
    public function getServiceNameAscii()
    {
        return $this->serviceNameAscii;
    }
    /**
     * Set serviceNameAscii value
     * @param string $serviceNameAscii
     * @return \StructType\XSubscribedService
     */
    public function setServiceNameAscii($serviceNameAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceNameAscii) && strlen($serviceNameAscii) > 50) || (is_array($serviceNameAscii) && count($serviceNameAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($serviceNameAscii) ? strlen($serviceNameAscii) : count($serviceNameAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceNameAscii) && !is_string($serviceNameAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceNameAscii)), __LINE__);
        }
        $this->serviceNameAscii = $serviceNameAscii;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XSubscribedService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
