<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteListMember StructType
 * @subpackage Structs
 */
class XRouteListMember extends AbstractStructBase
{
    /**
     * The routeGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routeGroupName;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $selectionOrder;
    /**
     * The useFullyQualifiedCallingPartyNumber
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $useFullyQualifiedCallingPartyNumber;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The callingPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The prefixDigitsOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * Constructor method for XRouteListMember
     * @uses XRouteListMember::setRouteGroupName()
     * @uses XRouteListMember::setSelectionOrder()
     * @uses XRouteListMember::setUseFullyQualifiedCallingPartyNumber()
     * @uses XRouteListMember::setCalledPartyTransformationMask()
     * @uses XRouteListMember::setCallingPartyTransformationMask()
     * @uses XRouteListMember::setDigitDiscardInstructionName()
     * @uses XRouteListMember::setCallingPartyPrefixDigits()
     * @uses XRouteListMember::setPrefixDigitsOut()
     * @uses XRouteListMember::setCallingPartyNumberingPlan()
     * @uses XRouteListMember::setCallingPartyNumberType()
     * @uses XRouteListMember::setCalledPartyNumberingPlan()
     * @uses XRouteListMember::setCalledPartyNumberType()
     * @param \StructType\XFkType $routeGroupName
     * @param string $selectionOrder
     * @param string $useFullyQualifiedCallingPartyNumber
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @param string $callingPartyPrefixDigits
     * @param string $prefixDigitsOut
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     */
    public function __construct(\StructType\XFkType $routeGroupName = null, $selectionOrder = null, $useFullyQualifiedCallingPartyNumber = 'Default', $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, \StructType\XFkType $digitDiscardInstructionName = null, $callingPartyPrefixDigits = null, $prefixDigitsOut = null, $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager')
    {
        $this
            ->setRouteGroupName($routeGroupName)
            ->setSelectionOrder($selectionOrder)
            ->setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType);
    }
    /**
     * Get routeGroupName value
     * @return \StructType\XFkType
     */
    public function getRouteGroupName()
    {
        return $this->routeGroupName;
    }
    /**
     * Set routeGroupName value
     * @param \StructType\XFkType $routeGroupName
     * @return \StructType\XRouteListMember
     */
    public function setRouteGroupName(\StructType\XFkType $routeGroupName = null)
    {
        $this->routeGroupName = $routeGroupName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\XRouteListMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Get useFullyQualifiedCallingPartyNumber value
     * @return string
     */
    public function getUseFullyQualifiedCallingPartyNumber()
    {
        return $this->useFullyQualifiedCallingPartyNumber;
    }
    /**
     * Set useFullyQualifiedCallingPartyNumber value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useFullyQualifiedCallingPartyNumber
     * @return \StructType\XRouteListMember
     */
    public function setUseFullyQualifiedCallingPartyNumber($useFullyQualifiedCallingPartyNumber = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useFullyQualifiedCallingPartyNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useFullyQualifiedCallingPartyNumber, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useFullyQualifiedCallingPartyNumber = $useFullyQualifiedCallingPartyNumber;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return \StructType\XRouteListMember
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyTransformationMask) && strlen($calledPartyTransformationMask) > 50) || (is_array($calledPartyTransformationMask) && count($calledPartyTransformationMask) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($calledPartyTransformationMask) ? strlen($calledPartyTransformationMask) : count($calledPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \StructType\XRouteListMember
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyTransformationMask) && strlen($callingPartyTransformationMask) > 50) || (is_array($callingPartyTransformationMask) && count($callingPartyTransformationMask) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyTransformationMask) ? strlen($callingPartyTransformationMask) : count($callingPartyTransformationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyTransformationMask)), __LINE__);
        }
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $digitDiscardInstructionName
     * @return \StructType\XRouteListMember
     */
    public function setDigitDiscardInstructionName(\StructType\XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \StructType\XRouteListMember
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyPrefixDigits) && strlen($callingPartyPrefixDigits) > 50) || (is_array($callingPartyPrefixDigits) && count($callingPartyPrefixDigits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyPrefixDigits) ? strlen($callingPartyPrefixDigits) : count($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyPrefixDigits)), __LINE__);
        }
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return isset($this->prefixDigitsOut) ? $this->prefixDigitsOut : null;
    }
    /**
     * Set prefixDigitsOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDigitsOut
     * @return \StructType\XRouteListMember
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigitsOut) && strlen($prefixDigitsOut) > 50) || (is_array($prefixDigitsOut) && count($prefixDigitsOut) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDigitsOut) ? strlen($prefixDigitsOut) : count($prefixDigitsOut)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigitsOut)), __LINE__);
        }
        if (is_null($prefixDigitsOut) || (is_array($prefixDigitsOut) && empty($prefixDigitsOut))) {
            unset($this->prefixDigitsOut);
        } else {
            $this->prefixDigitsOut = $prefixDigitsOut;
        }
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return \StructType\XRouteListMember
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return \StructType\XRouteListMember
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses \EnumType\XNumberingPlan::valueIsValid()
     * @uses \EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return \StructType\XRouteListMember
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', \EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses \EnumType\XPriOfNumber::valueIsValid()
     * @uses \EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return \StructType\XRouteListMember
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', \EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XRouteListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
