<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRouteGroupMember StructType
 * @subpackage Structs
 */
class XRouteGroupMember extends AbstractStructBase
{
    /**
     * The deviceSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $deviceSelectionOrder;
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $deviceName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $port;
    /**
     * Constructor method for XRouteGroupMember
     * @uses XRouteGroupMember::setDeviceSelectionOrder()
     * @uses XRouteGroupMember::setDeviceName()
     * @uses XRouteGroupMember::setPort()
     * @param string $deviceSelectionOrder
     * @param \StructType\XFkType $deviceName
     * @param string $port
     */
    public function __construct($deviceSelectionOrder = null, \StructType\XFkType $deviceName = null, $port = null)
    {
        $this
            ->setDeviceSelectionOrder($deviceSelectionOrder)
            ->setDeviceName($deviceName)
            ->setPort($port);
    }
    /**
     * Get deviceSelectionOrder value
     * @return string
     */
    public function getDeviceSelectionOrder()
    {
        return $this->deviceSelectionOrder;
    }
    /**
     * Set deviceSelectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSelectionOrder
     * @return \StructType\XRouteGroupMember
     */
    public function setDeviceSelectionOrder($deviceSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($deviceSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSelectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->deviceSelectionOrder = $deviceSelectionOrder;
        return $this;
    }
    /**
     * Get deviceName value
     * @return \StructType\XFkType
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \StructType\XFkType $deviceName
     * @return \StructType\XRouteGroupMember
     */
    public function setDeviceName(\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get port value
     * @return string
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XRouteGroupMember
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XRouteGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
