<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteClusterMember StructType
 * @subpackage Structs
 */
class XRemoteClusterMember extends AbstractStructBase
{
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * Constructor method for XRemoteClusterMember
     * @uses XRemoteClusterMember::setEnabled()
     * @param string $enabled
     */
    public function __construct($enabled = true)
    {
        $this
            ->setEnabled($enabled);
    }
    /**
     * Get enabled value
     * @return string
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\XRemoteClusterMember
     */
    public function setEnabled($enabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XRemoteClusterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
