<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteCluster StructType
 * @subpackage Structs
 */
class XRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The fullyQualifiedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $uds;
    /**
     * Constructor method for XRemoteCluster
     * @uses XRemoteCluster::setClusterId()
     * @uses XRemoteCluster::setFullyQualifiedName()
     * @uses XRemoteCluster::setDescription()
     * @uses XRemoteCluster::setEmcc()
     * @uses XRemoteCluster::setPstnAccess()
     * @uses XRemoteCluster::setRsvpAgent()
     * @uses XRemoteCluster::setTftp()
     * @uses XRemoteCluster::setLbm()
     * @uses XRemoteCluster::setUds()
     * @param string $clusterId
     * @param string $fullyQualifiedName
     * @param string $description
     * @param \StructType\XRemoteClusterMember $emcc
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @param \StructType\XRemoteClusterMember $tftp
     * @param \StructType\XRemoteClusterMember $lbm
     * @param \StructType\XRemoteClusterMember $uds
     */
    public function __construct($clusterId = null, $fullyQualifiedName = null, $description = null, \StructType\XRemoteClusterMember $emcc = null, \StructType\XRemoteClusterMember $pstnAccess = null, \StructType\XRemoteClusterMember $rsvpAgent = null, \StructType\XRemoteClusterMember $tftp = null, \StructType\XRemoteClusterMember $lbm = null, \StructType\XRemoteClusterMember $uds = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setDescription($description)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\XRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return \StructType\XRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullyQualifiedName) && strlen($fullyQualifiedName) > 50) || (is_array($fullyQualifiedName) && count($fullyQualifiedName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($fullyQualifiedName) ? strlen($fullyQualifiedName) : count($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\XRemoteClusterMember $emcc
     * @return \StructType\XRemoteCluster
     */
    public function setEmcc(\StructType\XRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @return \StructType\XRemoteCluster
     */
    public function setPstnAccess(\StructType\XRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @return \StructType\XRemoteCluster
     */
    public function setRsvpAgent(\StructType\XRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\XRemoteClusterMember $tftp
     * @return \StructType\XRemoteCluster
     */
    public function setTftp(\StructType\XRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\XRemoteClusterMember $lbm
     * @return \StructType\XRemoteCluster
     */
    public function setLbm(\StructType\XRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\XRemoteClusterMember $uds
     * @return \StructType\XRemoteCluster
     */
    public function setUds(\StructType\XRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XRemoteCluster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
