<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallerFilterList StructType
 * @subpackage Structs
 */
class XCallerFilterList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The isAllowedType
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAllowedType;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The endUserIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $endUserIdName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * Constructor method for XCallerFilterList
     * @uses XCallerFilterList::setName()
     * @uses XCallerFilterList::setIsAllowedType()
     * @uses XCallerFilterList::setDescription()
     * @uses XCallerFilterList::setEndUserIdName()
     * @uses XCallerFilterList::setMembers()
     * @param string $name
     * @param string $isAllowedType
     * @param string $description
     * @param \StructType\XFkType $endUserIdName
     * @param \StructType\Members $members
     */
    public function __construct($name = null, $isAllowedType = false, $description = null, \StructType\XFkType $endUserIdName = null, \StructType\Members $members = null)
    {
        $this
            ->setName($name)
            ->setIsAllowedType($isAllowedType)
            ->setDescription($description)
            ->setEndUserIdName($endUserIdName)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XCallerFilterList
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get isAllowedType value
     * @return string
     */
    public function getIsAllowedType()
    {
        return $this->isAllowedType;
    }
    /**
     * Set isAllowedType value
     * @param string $isAllowedType
     * @return \StructType\XCallerFilterList
     */
    public function setIsAllowedType($isAllowedType = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isAllowedType) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isAllowedType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isAllowedType) && !is_string($isAllowedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAllowedType)), __LINE__);
        }
        $this->isAllowedType = $isAllowedType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XCallerFilterList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get endUserIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getEndUserIdName()
    {
        return isset($this->endUserIdName) ? $this->endUserIdName : null;
    }
    /**
     * Set endUserIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $endUserIdName
     * @return \StructType\XCallerFilterList
     */
    public function setEndUserIdName(\StructType\XFkType $endUserIdName = null)
    {
        if (is_null($endUserIdName) || (is_array($endUserIdName) && empty($endUserIdName))) {
            unset($this->endUserIdName);
        } else {
            $this->endUserIdName = $endUserIdName;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XCallerFilterList
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XCallerFilterList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
