<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallManagerGroup StructType
 * @subpackage Structs
 */
class XCallManagerGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Members
     */
    public $members;
    /**
     * The tftpDefault
     * Meta informations extracted from the WSDL
     * - documentation: Only use when setting TFTP Default to true. Setting to true will result in setting all other CallManager groups to false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpDefault;
    /**
     * Constructor method for XCallManagerGroup
     * @uses XCallManagerGroup::setName()
     * @uses XCallManagerGroup::setMembers()
     * @uses XCallManagerGroup::setTftpDefault()
     * @param string $name
     * @param \StructType\Members $members
     * @param string $tftpDefault
     */
    public function __construct($name = null, \StructType\Members $members = null, $tftpDefault = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setTftpDefault($tftpDefault);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XCallManagerGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\XCallManagerGroup
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get tftpDefault value
     * @return string|null
     */
    public function getTftpDefault()
    {
        return $this->tftpDefault;
    }
    /**
     * Set tftpDefault value
     * @param string $tftpDefault
     * @return \StructType\XCallManagerGroup
     */
    public function setTftpDefault($tftpDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tftpDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($tftpDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tftpDefault) && !is_string($tftpDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpDefault)), __LINE__);
        }
        $this->tftpDefault = $tftpDefault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XCallManagerGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
