<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAarGroupMatrix StructType
 * @subpackage Structs
 */
class XAarGroupMatrix extends AbstractStructBase
{
    /**
     * The aarGroupFromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $aarGroupToName;
    /**
     * The prefixDigit
     * Meta informations extracted from the WSDL
     * - documentation: The new prefixDigit value for this particular AARGroup relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $prefixDigit;
    /**
     * Constructor method for XAarGroupMatrix
     * @uses XAarGroupMatrix::setAarGroupFromName()
     * @uses XAarGroupMatrix::setAarGroupToName()
     * @uses XAarGroupMatrix::setPrefixDigit()
     * @param \StructType\XFkType $aarGroupFromName
     * @param \StructType\XFkType $aarGroupToName
     * @param string $prefixDigit
     */
    public function __construct(\StructType\XFkType $aarGroupFromName = null, \StructType\XFkType $aarGroupToName = null, $prefixDigit = null)
    {
        $this
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName)
            ->setPrefixDigit($prefixDigit);
    }
    /**
     * Get aarGroupFromName value
     * @return \StructType\XFkType
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param \StructType\XFkType $aarGroupFromName
     * @return \StructType\XAarGroupMatrix
     */
    public function setAarGroupFromName(\StructType\XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return \StructType\XFkType
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param \StructType\XFkType $aarGroupToName
     * @return \StructType\XAarGroupMatrix
     */
    public function setAarGroupToName(\StructType\XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return \StructType\XAarGroupMatrix
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigit) && strlen($prefixDigit) > 255) || (is_array($prefixDigit) && count($prefixDigit) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($prefixDigit) ? strlen($prefixDigit) : count($prefixDigit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XAarGroupMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
