<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateWLANProfileReq StructType
 * @subpackage Structs
 */
class UpdateWLANProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The ssid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ssid;
    /**
     * The frequencyBand
     * Meta informations extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The userModifiable
     * Meta informations extracted from the WSDL
     * - default: Disallowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The authMethod
     * Meta informations extracted from the WSDL
     * - default: EAP-FAST
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authMethod;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pskPassphrase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassphrase;
    /**
     * The wepKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $passwordDescription;
    /**
     * The networkAccessProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $networkAccessProfile;
    /**
     * Constructor method for UpdateWLANProfileReq
     * @uses UpdateWLANProfileReq::setNewName()
     * @uses UpdateWLANProfileReq::setDescription()
     * @uses UpdateWLANProfileReq::setSsid()
     * @uses UpdateWLANProfileReq::setFrequencyBand()
     * @uses UpdateWLANProfileReq::setUserModifiable()
     * @uses UpdateWLANProfileReq::setAuthMethod()
     * @uses UpdateWLANProfileReq::setUserName()
     * @uses UpdateWLANProfileReq::setPassword()
     * @uses UpdateWLANProfileReq::setPskPassphrase()
     * @uses UpdateWLANProfileReq::setWepKey()
     * @uses UpdateWLANProfileReq::setPasswordDescription()
     * @uses UpdateWLANProfileReq::setNetworkAccessProfile()
     * @param string $newName
     * @param string $description
     * @param string $ssid
     * @param string $frequencyBand
     * @param string $userModifiable
     * @param string $authMethod
     * @param string $userName
     * @param string $password
     * @param string $pskPassphrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param \StructType\XFkType $networkAccessProfile
     */
    public function __construct($newName = null, $description = null, $ssid = null, $frequencyBand = 'Auto', $userModifiable = 'Disallowed', $authMethod = 'EAP-FAST', $userName = null, $password = null, $pskPassphrase = null, $wepKey = null, $passwordDescription = null, \StructType\XFkType $networkAccessProfile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSsid($ssid)
            ->setFrequencyBand($frequencyBand)
            ->setUserModifiable($userModifiable)
            ->setAuthMethod($authMethod)
            ->setUserName($userName)
            ->setPassword($password)
            ->setPskPassphrase($pskPassphrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setNetworkAccessProfile($networkAccessProfile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssid value
     * @return string|null
     */
    public function getSsid()
    {
        return $this->ssid;
    }
    /**
     * Set ssid value
     * @param string $ssid
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setSsid($ssid = null)
    {
        // validation for constraint: string
        if (!is_null($ssid) && !is_string($ssid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ssid)), __LINE__);
        }
        $this->ssid = $ssid;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @uses \EnumType\XWiFiFrequency::valueIsValid()
     * @uses \EnumType\XWiFiFrequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequencyBand
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XWiFiFrequency::valueIsValid($frequencyBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequencyBand, implode(', ', \EnumType\XWiFiFrequency::getValidValues())), __LINE__);
        }
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @uses \EnumType\XWLANProfileChanges::valueIsValid()
     * @uses \EnumType\XWLANProfileChanges::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userModifiable
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setUserModifiable($userModifiable = 'Disallowed')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XWLANProfileChanges::valueIsValid($userModifiable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userModifiable, implode(', ', \EnumType\XWLANProfileChanges::getValidValues())), __LINE__);
        }
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get authMethod value
     * @return string|null
     */
    public function getAuthMethod()
    {
        return $this->authMethod;
    }
    /**
     * Set authMethod value
     * @uses \EnumType\XWiFiAuthenticationMethod::valueIsValid()
     * @uses \EnumType\XWiFiAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authMethod
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setAuthMethod($authMethod = 'EAP-FAST')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XWiFiAuthenticationMethod::valueIsValid($authMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authMethod, implode(', ', \EnumType\XWiFiAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authMethod = $authMethod;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pskPassphrase value
     * @return string|null
     */
    public function getPskPassphrase()
    {
        return $this->pskPassphrase;
    }
    /**
     * Set pskPassphrase value
     * @param string $pskPassphrase
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setPskPassphrase($pskPassphrase = null)
    {
        // validation for constraint: string
        if (!is_null($pskPassphrase) && !is_string($pskPassphrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pskPassphrase)), __LINE__);
        }
        $this->pskPassphrase = $pskPassphrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setWepKey($wepKey = null)
    {
        // validation for constraint: string
        if (!is_null($wepKey) && !is_string($wepKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wepKey)), __LINE__);
        }
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        // validation for constraint: string
        if (!is_null($passwordDescription) && !is_string($passwordDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordDescription)), __LINE__);
        }
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get networkAccessProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getNetworkAccessProfile()
    {
        return isset($this->networkAccessProfile) ? $this->networkAccessProfile : null;
    }
    /**
     * Set networkAccessProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $networkAccessProfile
     * @return \StructType\UpdateWLANProfileReq
     */
    public function setNetworkAccessProfile(\StructType\XFkType $networkAccessProfile = null)
    {
        if (is_null($networkAccessProfile) || (is_array($networkAccessProfile) && empty($networkAccessProfile))) {
            unset($this->networkAccessProfile);
        } else {
            $this->networkAccessProfile = $networkAccessProfile;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateWLANProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
