<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailPilotReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailPilotReq extends APIRequest
{
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $dirn;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The cssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cssName;
    /**
     * The newDirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $newDirn;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The newCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $newCssName;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailPilot as Default. Instead, the corresponding tag of another VoiceMailPilot should be set to true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * Constructor method for UpdateVoiceMailPilotReq
     * @uses UpdateVoiceMailPilotReq::setDirn()
     * @uses UpdateVoiceMailPilotReq::setUuid()
     * @uses UpdateVoiceMailPilotReq::setCssName()
     * @uses UpdateVoiceMailPilotReq::setNewDirn()
     * @uses UpdateVoiceMailPilotReq::setDescription()
     * @uses UpdateVoiceMailPilotReq::setNewCssName()
     * @uses UpdateVoiceMailPilotReq::setIsDefault()
     * @param string $dirn
     * @param string $uuid
     * @param \StructType\XFkType $cssName
     * @param string $newDirn
     * @param string $description
     * @param \StructType\XFkType $newCssName
     * @param string $isDefault
     */
    public function __construct($dirn = null, $uuid = null, \StructType\XFkType $cssName = null, $newDirn = null, $description = null, \StructType\XFkType $newCssName = null, $isDefault = null)
    {
        $this
            ->setDirn($dirn)
            ->setUuid($uuid)
            ->setCssName($cssName)
            ->setNewDirn($newDirn)
            ->setDescription($description)
            ->setNewCssName($newCssName)
            ->setIsDefault($isDefault);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dirn) && strlen($dirn) > 255) || (is_array($dirn) && count($dirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dirn) ? strlen($dirn) : count($dirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get cssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCssName()
    {
        return isset($this->cssName) ? $this->cssName : null;
    }
    /**
     * Set cssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cssName
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setCssName(\StructType\XFkType $cssName = null)
    {
        if (is_null($cssName) || (is_array($cssName) && empty($cssName))) {
            unset($this->cssName);
        } else {
            $this->cssName = $cssName;
        }
        return $this;
    }
    /**
     * Get newDirn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewDirn()
    {
        return isset($this->newDirn) ? $this->newDirn : null;
    }
    /**
     * Set newDirn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newDirn
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setNewDirn($newDirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newDirn) && strlen($newDirn) > 255) || (is_array($newDirn) && count($newDirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($newDirn) ? strlen($newDirn) : count($newDirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newDirn) && !is_string($newDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDirn)), __LINE__);
        }
        if (is_null($newDirn) || (is_array($newDirn) && empty($newDirn))) {
            unset($this->newDirn);
        } else {
            $this->newDirn = $newDirn;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getNewCssName()
    {
        return isset($this->newCssName) ? $this->newCssName : null;
    }
    /**
     * Set newCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $newCssName
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setNewCssName(\StructType\XFkType $newCssName = null)
    {
        if (is_null($newCssName) || (is_array($newCssName) && empty($newCssName))) {
            unset($this->newCssName);
        } else {
            $this->newCssName = $newCssName;
        }
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateVoiceMailPilotReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
