<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipTrunkSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdateSipTrunkSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 64
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The incomingTransport
     * Meta informations extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingTransport;
    /**
     * The outgoingTransport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $outgoingTransport;
    /**
     * The digestAuthentication
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $digestAuthentication;
    /**
     * The noncePolicyTime
     * Meta informations extracted from the WSDL
     * - default: 600
     * - documentation: Only if digestAuthentication is enabled this value can be changed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $noncePolicyTime;
    /**
     * The x509SubjectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 4096
     * @var string
     */
    public $x509SubjectName;
    /**
     * The incomingPort
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $incomingPort;
    /**
     * The applLevelAuthentication
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applLevelAuthentication;
    /**
     * The acceptPresenceSubscription
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The transmitSecurityStatus
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitSecurityStatus;
    /**
     * The sipV150OutboundSdpOfferFiltering
     * Meta informations extracted from the WSDL
     * - default: Use Default Filter
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipV150OutboundSdpOfferFiltering;
    /**
     * The allowChargingHeader
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowChargingHeader;
    /**
     * Constructor method for UpdateSipTrunkSecurityProfileReq
     * @uses UpdateSipTrunkSecurityProfileReq::setNewName()
     * @uses UpdateSipTrunkSecurityProfileReq::setDescription()
     * @uses UpdateSipTrunkSecurityProfileReq::setSecurityMode()
     * @uses UpdateSipTrunkSecurityProfileReq::setIncomingTransport()
     * @uses UpdateSipTrunkSecurityProfileReq::setOutgoingTransport()
     * @uses UpdateSipTrunkSecurityProfileReq::setDigestAuthentication()
     * @uses UpdateSipTrunkSecurityProfileReq::setNoncePolicyTime()
     * @uses UpdateSipTrunkSecurityProfileReq::setX509SubjectName()
     * @uses UpdateSipTrunkSecurityProfileReq::setIncomingPort()
     * @uses UpdateSipTrunkSecurityProfileReq::setApplLevelAuthentication()
     * @uses UpdateSipTrunkSecurityProfileReq::setAcceptPresenceSubscription()
     * @uses UpdateSipTrunkSecurityProfileReq::setAcceptOutOfDialogRefer()
     * @uses UpdateSipTrunkSecurityProfileReq::setAcceptUnsolicitedNotification()
     * @uses UpdateSipTrunkSecurityProfileReq::setAllowReplaceHeader()
     * @uses UpdateSipTrunkSecurityProfileReq::setTransmitSecurityStatus()
     * @uses UpdateSipTrunkSecurityProfileReq::setSipV150OutboundSdpOfferFiltering()
     * @uses UpdateSipTrunkSecurityProfileReq::setAllowChargingHeader()
     * @param string $newName
     * @param string $description
     * @param string $securityMode
     * @param string $incomingTransport
     * @param string $outgoingTransport
     * @param string $digestAuthentication
     * @param string $noncePolicyTime
     * @param string $x509SubjectName
     * @param string $incomingPort
     * @param string $applLevelAuthentication
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $transmitSecurityStatus
     * @param string $sipV150OutboundSdpOfferFiltering
     * @param string $allowChargingHeader
     */
    public function __construct($newName = null, $description = null, $securityMode = null, $incomingTransport = 'TCP+UDP', $outgoingTransport = null, $digestAuthentication = false, $noncePolicyTime = '600', $x509SubjectName = null, $incomingPort = '5060', $applLevelAuthentication = false, $acceptPresenceSubscription = false, $acceptOutOfDialogRefer = false, $acceptUnsolicitedNotification = false, $allowReplaceHeader = false, $transmitSecurityStatus = false, $sipV150OutboundSdpOfferFiltering = 'Use Default Filter', $allowChargingHeader = false)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setIncomingTransport($incomingTransport)
            ->setOutgoingTransport($outgoingTransport)
            ->setDigestAuthentication($digestAuthentication)
            ->setNoncePolicyTime($noncePolicyTime)
            ->setX509SubjectName($x509SubjectName)
            ->setIncomingPort($incomingPort)
            ->setApplLevelAuthentication($applLevelAuthentication)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setTransmitSecurityStatus($transmitSecurityStatus)
            ->setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering)
            ->setAllowChargingHeader($allowChargingHeader);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 64) || (is_array($newName) && count($newName) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $securityMode, implode(', ', \EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get incomingTransport value
     * @return string|null
     */
    public function getIncomingTransport()
    {
        return $this->incomingTransport;
    }
    /**
     * Set incomingTransport value
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingTransport
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setIncomingTransport($incomingTransport = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($incomingTransport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $incomingTransport, implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->incomingTransport = $incomingTransport;
        return $this;
    }
    /**
     * Get outgoingTransport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingTransport()
    {
        return isset($this->outgoingTransport) ? $this->outgoingTransport : null;
    }
    /**
     * Set outgoingTransport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XTransport::valueIsValid()
     * @uses \EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outgoingTransport
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setOutgoingTransport($outgoingTransport = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTransport::valueIsValid($outgoingTransport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outgoingTransport, implode(', ', \EnumType\XTransport::getValidValues())), __LINE__);
        }
        if (is_null($outgoingTransport) || (is_array($outgoingTransport) && empty($outgoingTransport))) {
            unset($this->outgoingTransport);
        } else {
            $this->outgoingTransport = $outgoingTransport;
        }
        return $this;
    }
    /**
     * Get digestAuthentication value
     * @return string|null
     */
    public function getDigestAuthentication()
    {
        return $this->digestAuthentication;
    }
    /**
     * Set digestAuthentication value
     * @param string $digestAuthentication
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setDigestAuthentication($digestAuthentication = false)
    {
        // validation for constraint: pattern
        if (is_scalar($digestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($digestAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digestAuthentication) && !is_string($digestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestAuthentication)), __LINE__);
        }
        $this->digestAuthentication = $digestAuthentication;
        return $this;
    }
    /**
     * Get noncePolicyTime value
     * @return string|null
     */
    public function getNoncePolicyTime()
    {
        return $this->noncePolicyTime;
    }
    /**
     * Set noncePolicyTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noncePolicyTime
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setNoncePolicyTime($noncePolicyTime = '600')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($noncePolicyTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $noncePolicyTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->noncePolicyTime = $noncePolicyTime;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($x509SubjectName) && strlen($x509SubjectName) > 4096) || (is_array($x509SubjectName) && count($x509SubjectName) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($x509SubjectName) ? strlen($x509SubjectName) : count($x509SubjectName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get incomingPort value
     * @return string|null
     */
    public function getIncomingPort()
    {
        return $this->incomingPort;
    }
    /**
     * Set incomingPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incomingPort
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setIncomingPort($incomingPort = '5060')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($incomingPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $incomingPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->incomingPort = $incomingPort;
        return $this;
    }
    /**
     * Get applLevelAuthentication value
     * @return string|null
     */
    public function getApplLevelAuthentication()
    {
        return $this->applLevelAuthentication;
    }
    /**
     * Set applLevelAuthentication value
     * @param string $applLevelAuthentication
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setApplLevelAuthentication($applLevelAuthentication = false)
    {
        // validation for constraint: pattern
        if (is_scalar($applLevelAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($applLevelAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applLevelAuthentication) && !is_string($applLevelAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applLevelAuthentication)), __LINE__);
        }
        $this->applLevelAuthentication = $applLevelAuthentication;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = false)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptPresenceSubscription)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = false)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = false)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setAllowReplaceHeader($allowReplaceHeader = false)
    {
        // validation for constraint: pattern
        if (is_scalar($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowReplaceHeader, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowReplaceHeader)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get transmitSecurityStatus value
     * @return string|null
     */
    public function getTransmitSecurityStatus()
    {
        return $this->transmitSecurityStatus;
    }
    /**
     * Set transmitSecurityStatus value
     * @param string $transmitSecurityStatus
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setTransmitSecurityStatus($transmitSecurityStatus = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitSecurityStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitSecurityStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitSecurityStatus) && !is_string($transmitSecurityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitSecurityStatus)), __LINE__);
        }
        $this->transmitSecurityStatus = $transmitSecurityStatus;
        return $this;
    }
    /**
     * Get sipV150OutboundSdpOfferFiltering value
     * @return string|null
     */
    public function getSipV150OutboundSdpOfferFiltering()
    {
        return $this->sipV150OutboundSdpOfferFiltering;
    }
    /**
     * Set sipV150OutboundSdpOfferFiltering value
     * @uses \EnumType\XV150SDPFilter::valueIsValid()
     * @uses \EnumType\XV150SDPFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipV150OutboundSdpOfferFiltering
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setSipV150OutboundSdpOfferFiltering($sipV150OutboundSdpOfferFiltering = 'Use Default Filter')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XV150SDPFilter::valueIsValid($sipV150OutboundSdpOfferFiltering)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipV150OutboundSdpOfferFiltering, implode(', ', \EnumType\XV150SDPFilter::getValidValues())), __LINE__);
        }
        $this->sipV150OutboundSdpOfferFiltering = $sipV150OutboundSdpOfferFiltering;
        return $this;
    }
    /**
     * Get allowChargingHeader value
     * @return string|null
     */
    public function getAllowChargingHeader()
    {
        return $this->allowChargingHeader;
    }
    /**
     * Set allowChargingHeader value
     * @param string $allowChargingHeader
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public function setAllowChargingHeader($allowChargingHeader = false)
    {
        // validation for constraint: pattern
        if (is_scalar($allowChargingHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowChargingHeader, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowChargingHeader) && !is_string($allowChargingHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowChargingHeader)), __LINE__);
        }
        $this->allowChargingHeader = $allowChargingHeader;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSipTrunkSecurityProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
