<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSelfProvisioningReq StructType
 * @subpackage Structs
 */
class UpdateSelfProvisioningReq extends APIRequest
{
    /**
     * The requireAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requireAuthentication;
    /**
     * The allowAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $allowAuthentication;
    /**
     * The authenticationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authenticationCode;
    /**
     * The ctiRoutePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ctiRoutePoint;
    /**
     * The applicationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $applicationUser;
    /**
     * The removeLanguages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveLanguages
     */
    public $removeLanguages;
    /**
     * The addLanguages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddLanguages
     */
    public $addLanguages;
    /**
     * The languages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Languages
     */
    public $languages;
    /**
     * Constructor method for UpdateSelfProvisioningReq
     * @uses UpdateSelfProvisioningReq::setRequireAuthentication()
     * @uses UpdateSelfProvisioningReq::setAllowAuthentication()
     * @uses UpdateSelfProvisioningReq::setAuthenticationCode()
     * @uses UpdateSelfProvisioningReq::setCtiRoutePoint()
     * @uses UpdateSelfProvisioningReq::setApplicationUser()
     * @uses UpdateSelfProvisioningReq::setRemoveLanguages()
     * @uses UpdateSelfProvisioningReq::setAddLanguages()
     * @uses UpdateSelfProvisioningReq::setLanguages()
     * @param string $requireAuthentication
     * @param string $allowAuthentication
     * @param string $authenticationCode
     * @param string $ctiRoutePoint
     * @param string $applicationUser
     * @param \StructType\RemoveLanguages $removeLanguages
     * @param \StructType\AddLanguages $addLanguages
     * @param \StructType\Languages $languages
     */
    public function __construct($requireAuthentication = null, $allowAuthentication = null, $authenticationCode = null, $ctiRoutePoint = null, $applicationUser = null, \StructType\RemoveLanguages $removeLanguages = null, \StructType\AddLanguages $addLanguages = null, \StructType\Languages $languages = null)
    {
        $this
            ->setRequireAuthentication($requireAuthentication)
            ->setAllowAuthentication($allowAuthentication)
            ->setAuthenticationCode($authenticationCode)
            ->setCtiRoutePoint($ctiRoutePoint)
            ->setApplicationUser($applicationUser)
            ->setRemoveLanguages($removeLanguages)
            ->setAddLanguages($addLanguages)
            ->setLanguages($languages);
    }
    /**
     * Get requireAuthentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequireAuthentication()
    {
        return isset($this->requireAuthentication) ? $this->requireAuthentication : null;
    }
    /**
     * Set requireAuthentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requireAuthentication
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setRequireAuthentication($requireAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($requireAuthentication) && !is_string($requireAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireAuthentication)), __LINE__);
        }
        if (is_null($requireAuthentication) || (is_array($requireAuthentication) && empty($requireAuthentication))) {
            unset($this->requireAuthentication);
        } else {
            $this->requireAuthentication = $requireAuthentication;
        }
        return $this;
    }
    /**
     * Get allowAuthentication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowAuthentication()
    {
        return isset($this->allowAuthentication) ? $this->allowAuthentication : null;
    }
    /**
     * Set allowAuthentication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowAuthentication
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAllowAuthentication($allowAuthentication = null)
    {
        // validation for constraint: string
        if (!is_null($allowAuthentication) && !is_string($allowAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowAuthentication)), __LINE__);
        }
        if (is_null($allowAuthentication) || (is_array($allowAuthentication) && empty($allowAuthentication))) {
            unset($this->allowAuthentication);
        } else {
            $this->allowAuthentication = $allowAuthentication;
        }
        return $this;
    }
    /**
     * Get authenticationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationCode()
    {
        return isset($this->authenticationCode) ? $this->authenticationCode : null;
    }
    /**
     * Set authenticationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationCode
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAuthenticationCode($authenticationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationCode) && !is_string($authenticationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationCode)), __LINE__);
        }
        if (is_null($authenticationCode) || (is_array($authenticationCode) && empty($authenticationCode))) {
            unset($this->authenticationCode);
        } else {
            $this->authenticationCode = $authenticationCode;
        }
        return $this;
    }
    /**
     * Get ctiRoutePoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCtiRoutePoint()
    {
        return isset($this->ctiRoutePoint) ? $this->ctiRoutePoint : null;
    }
    /**
     * Set ctiRoutePoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ctiRoutePoint
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setCtiRoutePoint($ctiRoutePoint = null)
    {
        // validation for constraint: string
        if (!is_null($ctiRoutePoint) && !is_string($ctiRoutePoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ctiRoutePoint)), __LINE__);
        }
        if (is_null($ctiRoutePoint) || (is_array($ctiRoutePoint) && empty($ctiRoutePoint))) {
            unset($this->ctiRoutePoint);
        } else {
            $this->ctiRoutePoint = $ctiRoutePoint;
        }
        return $this;
    }
    /**
     * Get applicationUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationUser()
    {
        return isset($this->applicationUser) ? $this->applicationUser : null;
    }
    /**
     * Set applicationUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationUser
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setApplicationUser($applicationUser = null)
    {
        // validation for constraint: string
        if (!is_null($applicationUser) && !is_string($applicationUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationUser)), __LINE__);
        }
        if (is_null($applicationUser) || (is_array($applicationUser) && empty($applicationUser))) {
            unset($this->applicationUser);
        } else {
            $this->applicationUser = $applicationUser;
        }
        return $this;
    }
    /**
     * Get removeLanguages value
     * @return \StructType\RemoveLanguages|null
     */
    public function getRemoveLanguages()
    {
        return $this->removeLanguages;
    }
    /**
     * Set removeLanguages value
     * @param \StructType\RemoveLanguages $removeLanguages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setRemoveLanguages(\StructType\RemoveLanguages $removeLanguages = null)
    {
        $this->removeLanguages = $removeLanguages;
        return $this;
    }
    /**
     * Get addLanguages value
     * @return \StructType\AddLanguages|null
     */
    public function getAddLanguages()
    {
        return $this->addLanguages;
    }
    /**
     * Set addLanguages value
     * @param \StructType\AddLanguages $addLanguages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setAddLanguages(\StructType\AddLanguages $addLanguages = null)
    {
        $this->addLanguages = $addLanguages;
        return $this;
    }
    /**
     * Get languages value
     * @return \StructType\Languages|null
     */
    public function getLanguages()
    {
        return $this->languages;
    }
    /**
     * Set languages value
     * @param \StructType\Languages $languages
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public function setLanguages(\StructType\Languages $languages = null)
    {
        $this->languages = $languages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSelfProvisioningReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
