<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSNMPCommunityStringRes StructType
 * @subpackage Structs
 */
class UpdateSNMPCommunityStringRes extends APIResponse
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $message;
    /**
     * Constructor method for UpdateSNMPCommunityStringRes
     * @uses UpdateSNMPCommunityStringRes::setMessage()
     * @param string $message
     */
    public function __construct($message = null)
    {
        $this
            ->setMessage($message);
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\UpdateSNMPCommunityStringRes
     */
    public function setMessage($message = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($message) && strlen($message) > 32) || (is_array($message) && count($message) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($message) ? strlen($message) : count($message)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSNMPCommunityStringRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
