<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRouteGroupReq StructType
 * @subpackage Structs
 */
class UpdateRouteGroupReq extends NameAndGUIDRequest
{
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - default: Circular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * Constructor method for UpdateRouteGroupReq
     * @uses UpdateRouteGroupReq::setDistributionAlgorithm()
     * @uses UpdateRouteGroupReq::setRemoveMembers()
     * @uses UpdateRouteGroupReq::setAddMembers()
     * @uses UpdateRouteGroupReq::setMembers()
     * @uses UpdateRouteGroupReq::setNewName()
     * @param string $distributionAlgorithm
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param string $newName
     */
    public function __construct($distributionAlgorithm = 'Circular', \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, $newName = null)
    {
        $this
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setNewName($newName);
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \StructType\UpdateRouteGroupReq
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Circular')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', \EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateRouteGroupReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateRouteGroupReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\UpdateRouteGroupReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateRouteGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRouteGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
