<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMobileVoiceAccessReq StructType
 * @subpackage Structs
 */
class UpdateMobileVoiceAccessReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The removeLocales
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveLocales
     */
    public $removeLocales;
    /**
     * The addLocales
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddLocales
     */
    public $addLocales;
    /**
     * The locales
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Locales
     */
    public $locales;
    /**
     * Constructor method for UpdateMobileVoiceAccessReq
     * @uses UpdateMobileVoiceAccessReq::setPattern()
     * @uses UpdateMobileVoiceAccessReq::setUuid()
     * @uses UpdateMobileVoiceAccessReq::setNewPattern()
     * @uses UpdateMobileVoiceAccessReq::setRoutePartitionName()
     * @uses UpdateMobileVoiceAccessReq::setRemoveLocales()
     * @uses UpdateMobileVoiceAccessReq::setAddLocales()
     * @uses UpdateMobileVoiceAccessReq::setLocales()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param \StructType\XFkType $routePartitionName
     * @param \StructType\RemoveLocales $removeLocales
     * @param \StructType\AddLocales $addLocales
     * @param \StructType\Locales $locales
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, \StructType\XFkType $routePartitionName = null, \StructType\RemoveLocales $removeLocales = null, \StructType\AddLocales $addLocales = null, \StructType\Locales $locales = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setRoutePartitionName($routePartitionName)
            ->setRemoveLocales($removeLocales)
            ->setAddLocales($addLocales)
            ->setLocales($locales);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get removeLocales value
     * @return \StructType\RemoveLocales|null
     */
    public function getRemoveLocales()
    {
        return $this->removeLocales;
    }
    /**
     * Set removeLocales value
     * @param \StructType\RemoveLocales $removeLocales
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setRemoveLocales(\StructType\RemoveLocales $removeLocales = null)
    {
        $this->removeLocales = $removeLocales;
        return $this;
    }
    /**
     * Get addLocales value
     * @return \StructType\AddLocales|null
     */
    public function getAddLocales()
    {
        return $this->addLocales;
    }
    /**
     * Set addLocales value
     * @param \StructType\AddLocales $addLocales
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setAddLocales(\StructType\AddLocales $addLocales = null)
    {
        $this->addLocales = $addLocales;
        return $this;
    }
    /**
     * Get locales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Locales|null
     */
    public function getLocales()
    {
        return isset($this->locales) ? $this->locales : null;
    }
    /**
     * Set locales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Locales $locales
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public function setLocales(\StructType\Locales $locales = null)
    {
        if (is_null($locales) || (is_array($locales) && empty($locales))) {
            unset($this->locales);
        } else {
            $this->locales = $locales;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateMobileVoiceAccessReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
