<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLocationReq StructType
 * @subpackage Structs
 */
class UpdateLocationReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedLocations
     */
    public $relatedLocations;
    /**
     * The withinAudioBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinAudioBandwidth;
    /**
     * The withinVideoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinVideoBandwidth;
    /**
     * The withinImmersiveKbits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinImmersiveKbits;
    /**
     * The betweenLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BetweenLocations
     */
    public $betweenLocations;
    /**
     * Constructor method for UpdateLocationReq
     * @uses UpdateLocationReq::setNewName()
     * @uses UpdateLocationReq::setRelatedLocations()
     * @uses UpdateLocationReq::setWithinAudioBandwidth()
     * @uses UpdateLocationReq::setWithinVideoBandwidth()
     * @uses UpdateLocationReq::setWithinImmersiveKbits()
     * @uses UpdateLocationReq::setBetweenLocations()
     * @param string $newName
     * @param \StructType\RelatedLocations $relatedLocations
     * @param string $withinAudioBandwidth
     * @param string $withinVideoBandwidth
     * @param string $withinImmersiveKbits
     * @param \StructType\BetweenLocations $betweenLocations
     */
    public function __construct($newName = null, \StructType\RelatedLocations $relatedLocations = null, $withinAudioBandwidth = '0', $withinVideoBandwidth = '0', $withinImmersiveKbits = '0', \StructType\BetweenLocations $betweenLocations = null)
    {
        $this
            ->setNewName($newName)
            ->setRelatedLocations($relatedLocations)
            ->setWithinAudioBandwidth($withinAudioBandwidth)
            ->setWithinVideoBandwidth($withinVideoBandwidth)
            ->setWithinImmersiveKbits($withinImmersiveKbits)
            ->setBetweenLocations($betweenLocations);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateLocationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return \StructType\RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param \StructType\RelatedLocations $relatedLocations
     * @return \StructType\UpdateLocationReq
     */
    public function setRelatedLocations(\StructType\RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Get withinAudioBandwidth value
     * @return string|null
     */
    public function getWithinAudioBandwidth()
    {
        return $this->withinAudioBandwidth;
    }
    /**
     * Set withinAudioBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinAudioBandwidth
     * @return \StructType\UpdateLocationReq
     */
    public function setWithinAudioBandwidth($withinAudioBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinAudioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinAudioBandwidth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinAudioBandwidth = $withinAudioBandwidth;
        return $this;
    }
    /**
     * Get withinVideoBandwidth value
     * @return string|null
     */
    public function getWithinVideoBandwidth()
    {
        return $this->withinVideoBandwidth;
    }
    /**
     * Set withinVideoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinVideoBandwidth
     * @return \StructType\UpdateLocationReq
     */
    public function setWithinVideoBandwidth($withinVideoBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinVideoBandwidth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinVideoBandwidth = $withinVideoBandwidth;
        return $this;
    }
    /**
     * Get withinImmersiveKbits value
     * @return string|null
     */
    public function getWithinImmersiveKbits()
    {
        return $this->withinImmersiveKbits;
    }
    /**
     * Set withinImmersiveKbits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinImmersiveKbits
     * @return \StructType\UpdateLocationReq
     */
    public function setWithinImmersiveKbits($withinImmersiveKbits = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinImmersiveKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinImmersiveKbits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinImmersiveKbits = $withinImmersiveKbits;
        return $this;
    }
    /**
     * Get betweenLocations value
     * @return \StructType\BetweenLocations|null
     */
    public function getBetweenLocations()
    {
        return $this->betweenLocations;
    }
    /**
     * Set betweenLocations value
     * @param \StructType\BetweenLocations $betweenLocations
     * @return \StructType\UpdateLocationReq
     */
    public function setBetweenLocations(\StructType\BetweenLocations $betweenLocations = null)
    {
        $this->betweenLocations = $betweenLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLocationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
