<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLbmGroupReq StructType
 * @subpackage Structs
 */
class UpdateLbmGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $Description;
    /**
     * The ProcessnodeActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $ProcessnodeActive;
    /**
     * The ProcessnodeStandby
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $ProcessnodeStandby;
    /**
     * Constructor method for UpdateLbmGroupReq
     * @uses UpdateLbmGroupReq::setNewName()
     * @uses UpdateLbmGroupReq::setDescription()
     * @uses UpdateLbmGroupReq::setProcessnodeActive()
     * @uses UpdateLbmGroupReq::setProcessnodeStandby()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $processnodeActive
     * @param \StructType\XFkType $processnodeStandby
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $processnodeActive = null, \StructType\XFkType $processnodeStandby = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setProcessnodeActive($processnodeActive)
            ->setProcessnodeStandby($processnodeStandby);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateLbmGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\UpdateLbmGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ProcessnodeActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getProcessnodeActive()
    {
        return isset($this->ProcessnodeActive) ? $this->ProcessnodeActive : null;
    }
    /**
     * Set ProcessnodeActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $processnodeActive
     * @return \StructType\UpdateLbmGroupReq
     */
    public function setProcessnodeActive(\StructType\XFkType $processnodeActive = null)
    {
        if (is_null($processnodeActive) || (is_array($processnodeActive) && empty($processnodeActive))) {
            unset($this->ProcessnodeActive);
        } else {
            $this->ProcessnodeActive = $processnodeActive;
        }
        return $this;
    }
    /**
     * Get ProcessnodeStandby value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getProcessnodeStandby()
    {
        return isset($this->ProcessnodeStandby) ? $this->ProcessnodeStandby : null;
    }
    /**
     * Set ProcessnodeStandby value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $processnodeStandby
     * @return \StructType\UpdateLbmGroupReq
     */
    public function setProcessnodeStandby(\StructType\XFkType $processnodeStandby = null)
    {
        if (is_null($processnodeStandby) || (is_array($processnodeStandby) && empty($processnodeStandby))) {
            unset($this->ProcessnodeStandby);
        } else {
            $this->ProcessnodeStandby = $processnodeStandby;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLbmGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
