<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIpPhoneServicesReq StructType
 * @subpackage Structs
 */
class UpdateIpPhoneServicesReq extends APIRequest
{
    /**
     * The serviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $serviceName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newServiceName;
    /**
     * The asciiServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The secureServiceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceCategory
     * Meta informations extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The removeParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveParameters
     */
    public $removeParameters;
    /**
     * The addParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddParameters
     */
    public $addParameters;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for UpdateIpPhoneServicesReq
     * @uses UpdateIpPhoneServicesReq::setServiceName()
     * @uses UpdateIpPhoneServicesReq::setUuid()
     * @uses UpdateIpPhoneServicesReq::setNewServiceName()
     * @uses UpdateIpPhoneServicesReq::setAsciiServiceName()
     * @uses UpdateIpPhoneServicesReq::setServiceDescription()
     * @uses UpdateIpPhoneServicesReq::setServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setSecureServiceUrl()
     * @uses UpdateIpPhoneServicesReq::setServiceCategory()
     * @uses UpdateIpPhoneServicesReq::setServiceType()
     * @uses UpdateIpPhoneServicesReq::setServiceVendor()
     * @uses UpdateIpPhoneServicesReq::setServiceVersion()
     * @uses UpdateIpPhoneServicesReq::setEnabled()
     * @uses UpdateIpPhoneServicesReq::setRemoveParameters()
     * @uses UpdateIpPhoneServicesReq::setAddParameters()
     * @uses UpdateIpPhoneServicesReq::setParameters()
     * @param string $serviceName
     * @param string $uuid
     * @param string $newServiceName
     * @param string $asciiServiceName
     * @param string $serviceDescription
     * @param string $serviceUrl
     * @param string $secureServiceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param \StructType\RemoveParameters $removeParameters
     * @param \StructType\AddParameters $addParameters
     * @param \StructType\Parameters $parameters
     */
    public function __construct($serviceName = null, $uuid = null, $newServiceName = null, $asciiServiceName = null, $serviceDescription = null, $serviceUrl = null, $secureServiceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceVendor = null, $serviceVersion = null, $enabled = true, \StructType\RemoveParameters $removeParameters = null, \StructType\AddParameters $addParameters = null, \StructType\Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setUuid($uuid)
            ->setNewServiceName($newServiceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceDescription($serviceDescription)
            ->setServiceUrl($serviceUrl)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setRemoveParameters($removeParameters)
            ->setAddParameters($addParameters)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceName) && strlen($serviceName) > 128) || (is_array($serviceName) && count($serviceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceName) ? strlen($serviceName) : count($serviceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newServiceName value
     * @return string|null
     */
    public function getNewServiceName()
    {
        return $this->newServiceName;
    }
    /**
     * Set newServiceName value
     * @param string $newServiceName
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setNewServiceName($newServiceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newServiceName) && strlen($newServiceName) > 128) || (is_array($newServiceName) && count($newServiceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newServiceName) ? strlen($newServiceName) : count($newServiceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newServiceName) && !is_string($newServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newServiceName)), __LINE__);
        }
        $this->newServiceName = $newServiceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string|null
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiServiceName) && strlen($asciiServiceName) > 128) || (is_array($asciiServiceName) && count($asciiServiceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($asciiServiceName) ? strlen($asciiServiceName) : count($asciiServiceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDescription) && strlen($serviceDescription) > 128) || (is_array($serviceDescription) && count($serviceDescription) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceDescription) ? strlen($serviceDescription) : count($serviceDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescription)), __LINE__);
        }
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get serviceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceUrl()
    {
        return isset($this->serviceUrl) ? $this->serviceUrl : null;
    }
    /**
     * Set serviceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceUrl
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceUrl)), __LINE__);
        }
        if (is_null($serviceUrl) || (is_array($serviceUrl) && empty($serviceUrl))) {
            unset($this->serviceUrl);
        } else {
            $this->serviceUrl = $serviceUrl;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServiceUrl)), __LINE__);
        }
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceCategory, implode(', ', \EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\XPhoneService::valueIsValid()
     * @uses \EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setEnabled($enabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get removeParameters value
     * @return \StructType\RemoveParameters|null
     */
    public function getRemoveParameters()
    {
        return $this->removeParameters;
    }
    /**
     * Set removeParameters value
     * @param \StructType\RemoveParameters $removeParameters
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setRemoveParameters(\StructType\RemoveParameters $removeParameters = null)
    {
        $this->removeParameters = $removeParameters;
        return $this;
    }
    /**
     * Get addParameters value
     * @return \StructType\AddParameters|null
     */
    public function getAddParameters()
    {
        return $this->addParameters;
    }
    /**
     * Set addParameters value
     * @param \StructType\AddParameters $addParameters
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setAddParameters(\StructType\AddParameters $addParameters = null)
    {
        $this->addParameters = $addParameters;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\Parameters $parameters
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public function setParameters(\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateIpPhoneServicesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
