<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeClientReq StructType
 * @subpackage Structs
 */
class UpdateImeClientReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $firewallName;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The removeCcmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveCcmExternalIpMaps
     */
    public $removeCcmExternalIpMaps;
    /**
     * The addCcmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddCcmExternalIpMaps
     */
    public $addCcmExternalIpMaps;
    /**
     * The ccmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * Constructor method for UpdateImeClientReq
     * @uses UpdateImeClientReq::setNewName()
     * @uses UpdateImeClientReq::setDescription()
     * @uses UpdateImeClientReq::setDomain()
     * @uses UpdateImeClientReq::setIsActivated()
     * @uses UpdateImeClientReq::setSipTrunkName()
     * @uses UpdateImeClientReq::setPrimaryImeServerName()
     * @uses UpdateImeClientReq::setSecondaryImeServerName()
     * @uses UpdateImeClientReq::setLearnedRouteFilterGroupName()
     * @uses UpdateImeClientReq::setExclusionNumberGroupName()
     * @uses UpdateImeClientReq::setFirewallName()
     * @uses UpdateImeClientReq::setRemoveMembers()
     * @uses UpdateImeClientReq::setAddMembers()
     * @uses UpdateImeClientReq::setMembers()
     * @uses UpdateImeClientReq::setRemoveCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setAddCcmExternalIpMaps()
     * @uses UpdateImeClientReq::setCcmExternalIpMaps()
     * @param string $newName
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     * @param \StructType\XFkType $primaryImeServerName
     * @param \StructType\XFkType $secondaryImeServerName
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @param \StructType\XFkType $firewallName
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @param \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     */
    public function __construct($newName = null, $description = null, $domain = null, $isActivated = false, \StructType\XFkType $sipTrunkName = null, \StructType\XFkType $primaryImeServerName = null, \StructType\XFkType $secondaryImeServerName = null, \StructType\XFkType $learnedRouteFilterGroupName = null, \StructType\XFkType $exclusionNumberGroupName = null, \StructType\XFkType $firewallName = null, \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null, \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps = null, \StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setRemoveCcmExternalIpMaps($removeCcmExternalIpMaps)
            ->setAddCcmExternalIpMaps($addCcmExternalIpMaps)
            ->setCcmExternalIpMaps($ccmExternalIpMaps);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeClientReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeClientReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\UpdateImeClientReq
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($domain) && strlen($domain) > 255) || (is_array($domain) && count($domain) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($domain) ? strlen($domain) : count($domain)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\UpdateImeClientReq
     */
    public function setIsActivated($isActivated = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\UpdateImeClientReq
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return \StructType\XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param \StructType\XFkType $primaryImeServerName
     * @return \StructType\UpdateImeClientReq
     */
    public function setPrimaryImeServerName(\StructType\XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return isset($this->secondaryImeServerName) ? $this->secondaryImeServerName : null;
    }
    /**
     * Set secondaryImeServerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $secondaryImeServerName
     * @return \StructType\UpdateImeClientReq
     */
    public function setSecondaryImeServerName(\StructType\XFkType $secondaryImeServerName = null)
    {
        if (is_null($secondaryImeServerName) || (is_array($secondaryImeServerName) && empty($secondaryImeServerName))) {
            unset($this->secondaryImeServerName);
        } else {
            $this->secondaryImeServerName = $secondaryImeServerName;
        }
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return isset($this->learnedRouteFilterGroupName) ? $this->learnedRouteFilterGroupName : null;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $learnedRouteFilterGroupName
     * @return \StructType\UpdateImeClientReq
     */
    public function setLearnedRouteFilterGroupName(\StructType\XFkType $learnedRouteFilterGroupName = null)
    {
        if (is_null($learnedRouteFilterGroupName) || (is_array($learnedRouteFilterGroupName) && empty($learnedRouteFilterGroupName))) {
            unset($this->learnedRouteFilterGroupName);
        } else {
            $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        }
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return isset($this->exclusionNumberGroupName) ? $this->exclusionNumberGroupName : null;
    }
    /**
     * Set exclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $exclusionNumberGroupName
     * @return \StructType\UpdateImeClientReq
     */
    public function setExclusionNumberGroupName(\StructType\XFkType $exclusionNumberGroupName = null)
    {
        if (is_null($exclusionNumberGroupName) || (is_array($exclusionNumberGroupName) && empty($exclusionNumberGroupName))) {
            unset($this->exclusionNumberGroupName);
        } else {
            $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Get firewallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getFirewallName()
    {
        return isset($this->firewallName) ? $this->firewallName : null;
    }
    /**
     * Set firewallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $firewallName
     * @return \StructType\UpdateImeClientReq
     */
    public function setFirewallName(\StructType\XFkType $firewallName = null)
    {
        if (is_null($firewallName) || (is_array($firewallName) && empty($firewallName))) {
            unset($this->firewallName);
        } else {
            $this->firewallName = $firewallName;
        }
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateImeClientReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateImeClientReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\UpdateImeClientReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get removeCcmExternalIpMaps value
     * @return \StructType\RemoveCcmExternalIpMaps|null
     */
    public function getRemoveCcmExternalIpMaps()
    {
        return $this->removeCcmExternalIpMaps;
    }
    /**
     * Set removeCcmExternalIpMaps value
     * @param \StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setRemoveCcmExternalIpMaps(\StructType\RemoveCcmExternalIpMaps $removeCcmExternalIpMaps = null)
    {
        $this->removeCcmExternalIpMaps = $removeCcmExternalIpMaps;
        return $this;
    }
    /**
     * Get addCcmExternalIpMaps value
     * @return \StructType\AddCcmExternalIpMaps|null
     */
    public function getAddCcmExternalIpMaps()
    {
        return $this->addCcmExternalIpMaps;
    }
    /**
     * Set addCcmExternalIpMaps value
     * @param \StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setAddCcmExternalIpMaps(\StructType\AddCcmExternalIpMaps $addCcmExternalIpMaps = null)
    {
        $this->addCcmExternalIpMaps = $addCcmExternalIpMaps;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return \StructType\CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param \StructType\CcmExternalIpMaps $ccmExternalIpMaps
     * @return \StructType\UpdateImeClientReq
     */
    public function setCcmExternalIpMaps(\StructType\CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateImeClientReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
